// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The command type.
 */
public final class DataFlowDebugCommandType extends ExpandableStringEnum<DataFlowDebugCommandType> {
    /**
     * Static value executePreviewQuery for DataFlowDebugCommandType.
     */
    public static final DataFlowDebugCommandType EXECUTE_PREVIEW_QUERY = fromString("executePreviewQuery");

    /**
     * Static value executeStatisticsQuery for DataFlowDebugCommandType.
     */
    public static final DataFlowDebugCommandType EXECUTE_STATISTICS_QUERY = fromString("executeStatisticsQuery");

    /**
     * Static value executeExpressionQuery for DataFlowDebugCommandType.
     */
    public static final DataFlowDebugCommandType EXECUTE_EXPRESSION_QUERY = fromString("executeExpressionQuery");

    /**
     * Creates a new instance of DataFlowDebugCommandType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DataFlowDebugCommandType() {
    }

    /**
     * Creates or finds a DataFlowDebugCommandType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DataFlowDebugCommandType.
     */
    @JsonCreator
    public static DataFlowDebugCommandType fromString(String name) {
        return fromString(name, DataFlowDebugCommandType.class);
    }

    /**
     * Gets known DataFlowDebugCommandType values.
     * 
     * @return known DataFlowDebugCommandType values.
     */
    public static Collection<DataFlowDebugCommandType> values() {
        return values(DataFlowDebugCommandType.class);
    }
}
