// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Data flow debug settings.
 */
@Fluent
public final class DataFlowDebugPackageDebugSettings {
    /*
     * Source setting for data flow debug.
     */
    @JsonProperty(value = "sourceSettings")
    private List<DataFlowSourceSetting> sourceSettings;

    /*
     * Data flow parameters.
     */
    @JsonProperty(value = "parameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> parameters;

    /*
     * Parameters for dataset.
     */
    @JsonProperty(value = "datasetParameters")
    private Object datasetParameters;

    /**
     * Creates an instance of DataFlowDebugPackageDebugSettings class.
     */
    public DataFlowDebugPackageDebugSettings() {
    }

    /**
     * Get the sourceSettings property: Source setting for data flow debug.
     * 
     * @return the sourceSettings value.
     */
    public List<DataFlowSourceSetting> sourceSettings() {
        return this.sourceSettings;
    }

    /**
     * Set the sourceSettings property: Source setting for data flow debug.
     * 
     * @param sourceSettings the sourceSettings value to set.
     * @return the DataFlowDebugPackageDebugSettings object itself.
     */
    public DataFlowDebugPackageDebugSettings withSourceSettings(List<DataFlowSourceSetting> sourceSettings) {
        this.sourceSettings = sourceSettings;
        return this;
    }

    /**
     * Get the parameters property: Data flow parameters.
     * 
     * @return the parameters value.
     */
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Data flow parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the DataFlowDebugPackageDebugSettings object itself.
     */
    public DataFlowDebugPackageDebugSettings withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the datasetParameters property: Parameters for dataset.
     * 
     * @return the datasetParameters value.
     */
    public Object datasetParameters() {
        return this.datasetParameters;
    }

    /**
     * Set the datasetParameters property: Parameters for dataset.
     * 
     * @param datasetParameters the datasetParameters value to set.
     * @return the DataFlowDebugPackageDebugSettings object itself.
     */
    public DataFlowDebugPackageDebugSettings withDatasetParameters(Object datasetParameters) {
        this.datasetParameters = datasetParameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceSettings() != null) {
            sourceSettings().forEach(e -> e.validate());
        }
    }
}
