// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of DataFlowDebugSessions.
 */
public interface DataFlowDebugSessions {
    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session.
     */
    CreateDataFlowDebugSessionResponse create(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request);

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session.
     */
    CreateDataFlowDebugSessionResponse create(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request, Context context);

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions as paginated response with {@link PagedIterable}.
     */
    PagedIterable<DataFlowDebugSessionInfo> queryByFactory(String resourceGroupName, String factoryName);

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions as paginated response with {@link PagedIterable}.
     */
    PagedIterable<DataFlowDebugSessionInfo> queryByFactory(String resourceGroupName, String factoryName,
        Context context);

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session along with {@link Response}.
     */
    Response<AddDataFlowToDebugSessionResponse> addDataFlowWithResponse(String resourceGroupName, String factoryName,
        DataFlowDebugPackage request, Context context);

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session.
     */
    AddDataFlowToDebugSessionResponse addDataFlow(String resourceGroupName, String factoryName,
        DataFlowDebugPackage request);

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String factoryName,
        DeleteDataFlowDebugSessionRequest request, Context context);

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String factoryName, DeleteDataFlowDebugSessionRequest request);

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview.
     */
    DataFlowDebugCommandResponse executeCommand(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request);

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview.
     */
    DataFlowDebugCommandResponse executeCommand(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request, Context context);
}
