// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Transformation for data flow sink.
 */
@Fluent
public class DataFlowSink extends Transformation {
    /*
     * Schema linked service reference.
     */
    @JsonProperty(value = "schemaLinkedService")
    private LinkedServiceReference schemaLinkedService;

    /*
     * Rejected data linked service reference.
     */
    @JsonProperty(value = "rejectedDataLinkedService")
    private LinkedServiceReference rejectedDataLinkedService;

    /**
     * Creates an instance of DataFlowSink class.
     */
    public DataFlowSink() {
    }

    /**
     * Get the schemaLinkedService property: Schema linked service reference.
     * 
     * @return the schemaLinkedService value.
     */
    public LinkedServiceReference schemaLinkedService() {
        return this.schemaLinkedService;
    }

    /**
     * Set the schemaLinkedService property: Schema linked service reference.
     * 
     * @param schemaLinkedService the schemaLinkedService value to set.
     * @return the DataFlowSink object itself.
     */
    public DataFlowSink withSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        this.schemaLinkedService = schemaLinkedService;
        return this;
    }

    /**
     * Get the rejectedDataLinkedService property: Rejected data linked service reference.
     * 
     * @return the rejectedDataLinkedService value.
     */
    public LinkedServiceReference rejectedDataLinkedService() {
        return this.rejectedDataLinkedService;
    }

    /**
     * Set the rejectedDataLinkedService property: Rejected data linked service reference.
     * 
     * @param rejectedDataLinkedService the rejectedDataLinkedService value to set.
     * @return the DataFlowSink object itself.
     */
    public DataFlowSink withRejectedDataLinkedService(LinkedServiceReference rejectedDataLinkedService) {
        this.rejectedDataLinkedService = rejectedDataLinkedService;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataFlowSink withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataFlowSink withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataFlowSink withDataset(DatasetReference dataset) {
        super.withDataset(dataset);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataFlowSink withLinkedService(LinkedServiceReference linkedService) {
        super.withLinkedService(linkedService);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataFlowSink withFlowlet(DataFlowReference flowlet) {
        super.withFlowlet(flowlet);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (schemaLinkedService() != null) {
            schemaLinkedService().validate();
        }
        if (rejectedDataLinkedService() != null) {
            rejectedDataLinkedService().validate();
        }
    }
}
