// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Staging info for execute data flow activity.
 */
@Fluent
public final class DataFlowStagingInfo {
    /*
     * Staging linked service reference.
     */
    @JsonProperty(value = "linkedService")
    private LinkedServiceReference linkedService;

    /*
     * Folder path for staging blob. Type: string (or Expression with resultType string)
     */
    @JsonProperty(value = "folderPath")
    private Object folderPath;

    /**
     * Creates an instance of DataFlowStagingInfo class.
     */
    public DataFlowStagingInfo() {
    }

    /**
     * Get the linkedService property: Staging linked service reference.
     * 
     * @return the linkedService value.
     */
    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    /**
     * Set the linkedService property: Staging linked service reference.
     * 
     * @param linkedService the linkedService value to set.
     * @return the DataFlowStagingInfo object itself.
     */
    public DataFlowStagingInfo withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    /**
     * Get the folderPath property: Folder path for staging blob. Type: string (or Expression with resultType string).
     * 
     * @return the folderPath value.
     */
    public Object folderPath() {
        return this.folderPath;
    }

    /**
     * Set the folderPath property: Folder path for staging blob. Type: string (or Expression with resultType string).
     * 
     * @param folderPath the folderPath value to set.
     * @return the DataFlowStagingInfo object itself.
     */
    public DataFlowStagingInfo withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedService() != null) {
            linkedService().validate();
        }
    }
}
