// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Source and target table mapping details.
 */
@Fluent
public final class DataMapperMapping {
    /*
     * Name of the target table
     */
    @JsonProperty(value = "targetEntityName")
    private String targetEntityName;

    /*
     * Name of the source table
     */
    @JsonProperty(value = "sourceEntityName")
    private String sourceEntityName;

    /*
     * The connection reference for the source connection.
     */
    @JsonProperty(value = "sourceConnectionReference")
    private MapperConnectionReference sourceConnectionReference;

    /*
     * This holds the user provided attribute mapping information.
     */
    @JsonProperty(value = "attributeMappingInfo")
    private MapperAttributeMappings attributeMappingInfo;

    /*
     * This holds the source denormalization information used while joining multiple sources.
     */
    @JsonProperty(value = "sourceDenormalizeInfo")
    private Object sourceDenormalizeInfo;

    /**
     * Creates an instance of DataMapperMapping class.
     */
    public DataMapperMapping() {
    }

    /**
     * Get the targetEntityName property: Name of the target table.
     * 
     * @return the targetEntityName value.
     */
    public String targetEntityName() {
        return this.targetEntityName;
    }

    /**
     * Set the targetEntityName property: Name of the target table.
     * 
     * @param targetEntityName the targetEntityName value to set.
     * @return the DataMapperMapping object itself.
     */
    public DataMapperMapping withTargetEntityName(String targetEntityName) {
        this.targetEntityName = targetEntityName;
        return this;
    }

    /**
     * Get the sourceEntityName property: Name of the source table.
     * 
     * @return the sourceEntityName value.
     */
    public String sourceEntityName() {
        return this.sourceEntityName;
    }

    /**
     * Set the sourceEntityName property: Name of the source table.
     * 
     * @param sourceEntityName the sourceEntityName value to set.
     * @return the DataMapperMapping object itself.
     */
    public DataMapperMapping withSourceEntityName(String sourceEntityName) {
        this.sourceEntityName = sourceEntityName;
        return this;
    }

    /**
     * Get the sourceConnectionReference property: The connection reference for the source connection.
     * 
     * @return the sourceConnectionReference value.
     */
    public MapperConnectionReference sourceConnectionReference() {
        return this.sourceConnectionReference;
    }

    /**
     * Set the sourceConnectionReference property: The connection reference for the source connection.
     * 
     * @param sourceConnectionReference the sourceConnectionReference value to set.
     * @return the DataMapperMapping object itself.
     */
    public DataMapperMapping withSourceConnectionReference(MapperConnectionReference sourceConnectionReference) {
        this.sourceConnectionReference = sourceConnectionReference;
        return this;
    }

    /**
     * Get the attributeMappingInfo property: This holds the user provided attribute mapping information.
     * 
     * @return the attributeMappingInfo value.
     */
    public MapperAttributeMappings attributeMappingInfo() {
        return this.attributeMappingInfo;
    }

    /**
     * Set the attributeMappingInfo property: This holds the user provided attribute mapping information.
     * 
     * @param attributeMappingInfo the attributeMappingInfo value to set.
     * @return the DataMapperMapping object itself.
     */
    public DataMapperMapping withAttributeMappingInfo(MapperAttributeMappings attributeMappingInfo) {
        this.attributeMappingInfo = attributeMappingInfo;
        return this;
    }

    /**
     * Get the sourceDenormalizeInfo property: This holds the source denormalization information used while joining
     * multiple sources.
     * 
     * @return the sourceDenormalizeInfo value.
     */
    public Object sourceDenormalizeInfo() {
        return this.sourceDenormalizeInfo;
    }

    /**
     * Set the sourceDenormalizeInfo property: This holds the source denormalization information used while joining
     * multiple sources.
     * 
     * @param sourceDenormalizeInfo the sourceDenormalizeInfo value to set.
     * @return the DataMapperMapping object itself.
     */
    public DataMapperMapping withSourceDenormalizeInfo(Object sourceDenormalizeInfo) {
        this.sourceDenormalizeInfo = sourceDenormalizeInfo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceConnectionReference() != null) {
            sourceConnectionReference().validate();
        }
        if (attributeMappingInfo() != null) {
            attributeMappingInfo().validate();
        }
    }
}
