// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.DatabricksSparkPythonActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * DatabricksSparkPython activity.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = DatabricksSparkPythonActivity.class,
    visible = true)
@JsonTypeName("DatabricksSparkPython")
@Fluent
public final class DatabricksSparkPythonActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "DatabricksSparkPython";

    /*
     * Databricks SparkPython activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private DatabricksSparkPythonActivityTypeProperties innerTypeProperties
        = new DatabricksSparkPythonActivityTypeProperties();

    /**
     * Creates an instance of DatabricksSparkPythonActivity class.
     */
    public DatabricksSparkPythonActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Databricks SparkPython activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private DatabricksSparkPythonActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatabricksSparkPythonActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the pythonFile property: The URI of the Python file to be executed. DBFS paths are supported. Type: string
     * (or Expression with resultType string).
     * 
     * @return the pythonFile value.
     */
    public Object pythonFile() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pythonFile();
    }

    /**
     * Set the pythonFile property: The URI of the Python file to be executed. DBFS paths are supported. Type: string
     * (or Expression with resultType string).
     * 
     * @param pythonFile the pythonFile value to set.
     * @return the DatabricksSparkPythonActivity object itself.
     */
    public DatabricksSparkPythonActivity withPythonFile(Object pythonFile) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
        }
        this.innerTypeProperties().withPythonFile(pythonFile);
        return this;
    }

    /**
     * Get the parameters property: Command line parameters that will be passed to the Python file.
     * 
     * @return the parameters value.
     */
    public List<Object> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    /**
     * Set the parameters property: Command line parameters that will be passed to the Python file.
     * 
     * @param parameters the parameters value to set.
     * @return the DatabricksSparkPythonActivity object itself.
     */
    public DatabricksSparkPythonActivity withParameters(List<Object> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the libraries property: A list of libraries to be installed on the cluster that will execute the job.
     * 
     * @return the libraries value.
     */
    public List<Map<String, Object>> libraries() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().libraries();
    }

    /**
     * Set the libraries property: A list of libraries to be installed on the cluster that will execute the job.
     * 
     * @param libraries the libraries value to set.
     * @return the DatabricksSparkPythonActivity object itself.
     */
    public DatabricksSparkPythonActivity withLibraries(List<Map<String, Object>> libraries) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
        }
        this.innerTypeProperties().withLibraries(libraries);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model DatabricksSparkPythonActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabricksSparkPythonActivity.class);
}
