// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Dataset debug resource.
 */
@Fluent
public final class DatasetDebugResource extends SubResourceDebugResource {
    /*
     * Dataset properties.
     */
    @JsonProperty(value = "properties", required = true)
    private Dataset properties;

    /**
     * Creates an instance of DatasetDebugResource class.
     */
    public DatasetDebugResource() {
    }

    /**
     * Get the properties property: Dataset properties.
     * 
     * @return the properties value.
     */
    public Dataset properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Dataset properties.
     * 
     * @param properties the properties value to set.
     * @return the DatasetDebugResource object itself.
     */
    public DatasetDebugResource withProperties(Dataset properties) {
        this.properties = properties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DatasetDebugResource withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property properties in model DatasetDebugResource"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatasetDebugResource.class);
}
