// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.DeleteActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Delete activity.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = DeleteActivity.class, visible = true)
@JsonTypeName("Delete")
@Fluent
public final class DeleteActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Delete";

    /*
     * Delete activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private DeleteActivityTypeProperties innerTypeProperties = new DeleteActivityTypeProperties();

    /**
     * Creates an instance of DeleteActivity class.
     */
    public DeleteActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Delete activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private DeleteActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the recursive property: If true, files or sub-folders under current folder path will be deleted recursively.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the recursive value.
     */
    public Object recursive() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().recursive();
    }

    /**
     * Set the recursive property: If true, files or sub-folders under current folder path will be deleted recursively.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param recursive the recursive value to set.
     * @return the DeleteActivity object itself.
     */
    public DeleteActivity withRecursive(Object recursive) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withRecursive(recursive);
        return this;
    }

    /**
     * Get the maxConcurrentConnections property: The max concurrent connections to connect data source at the same
     * time.
     * 
     * @return the maxConcurrentConnections value.
     */
    public Integer maxConcurrentConnections() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxConcurrentConnections();
    }

    /**
     * Set the maxConcurrentConnections property: The max concurrent connections to connect data source at the same
     * time.
     * 
     * @param maxConcurrentConnections the maxConcurrentConnections value to set.
     * @return the DeleteActivity object itself.
     */
    public DeleteActivity withMaxConcurrentConnections(Integer maxConcurrentConnections) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * Get the enableLogging property: Whether to record detailed logs of delete-activity execution. Default value is
     * false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the enableLogging value.
     */
    public Object enableLogging() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableLogging();
    }

    /**
     * Set the enableLogging property: Whether to record detailed logs of delete-activity execution. Default value is
     * false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param enableLogging the enableLogging value to set.
     * @return the DeleteActivity object itself.
     */
    public DeleteActivity withEnableLogging(Object enableLogging) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withEnableLogging(enableLogging);
        return this;
    }

    /**
     * Get the logStorageSettings property: Log storage settings customer need to provide when enableLogging is true.
     * 
     * @return the logStorageSettings value.
     */
    public LogStorageSettings logStorageSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logStorageSettings();
    }

    /**
     * Set the logStorageSettings property: Log storage settings customer need to provide when enableLogging is true.
     * 
     * @param logStorageSettings the logStorageSettings value to set.
     * @return the DeleteActivity object itself.
     */
    public DeleteActivity withLogStorageSettings(LogStorageSettings logStorageSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withLogStorageSettings(logStorageSettings);
        return this;
    }

    /**
     * Get the dataset property: Delete activity dataset reference.
     * 
     * @return the dataset value.
     */
    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    /**
     * Set the dataset property: Delete activity dataset reference.
     * 
     * @param dataset the dataset value to set.
     * @return the DeleteActivity object itself.
     */
    public DeleteActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    /**
     * Get the storeSettings property: Delete activity store settings.
     * 
     * @return the storeSettings value.
     */
    public StoreReadSettings storeSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storeSettings();
    }

    /**
     * Set the storeSettings property: Delete activity store settings.
     * 
     * @param storeSettings the storeSettings value to set.
     * @return the DeleteActivity object itself.
     */
    public DeleteActivity withStoreSettings(StoreReadSettings storeSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withStoreSettings(storeSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model DeleteActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeleteActivity.class);
}
