// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Delimited text write settings.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = DelimitedTextWriteSettings.class,
    visible = true)
@JsonTypeName("DelimitedTextWriteSettings")
@Fluent
public final class DelimitedTextWriteSettings extends FormatWriteSettings {
    /*
     * The write setting type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "DelimitedTextWriteSettings";

    /*
     * Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "quoteAllText")
    private Object quoteAllText;

    /*
     * The file extension used to create the files. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "fileExtension", required = true)
    private Object fileExtension;

    /*
     * Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "maxRowsPerFile")
    private Object maxRowsPerFile;

    /*
     * Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "fileNamePrefix")
    private Object fileNamePrefix;

    /**
     * Creates an instance of DelimitedTextWriteSettings class.
     */
    public DelimitedTextWriteSettings() {
    }

    /**
     * Get the type property: The write setting type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the quoteAllText property: Indicates whether string values should always be enclosed with quotes. Type:
     * boolean (or Expression with resultType boolean).
     * 
     * @return the quoteAllText value.
     */
    public Object quoteAllText() {
        return this.quoteAllText;
    }

    /**
     * Set the quoteAllText property: Indicates whether string values should always be enclosed with quotes. Type:
     * boolean (or Expression with resultType boolean).
     * 
     * @param quoteAllText the quoteAllText value to set.
     * @return the DelimitedTextWriteSettings object itself.
     */
    public DelimitedTextWriteSettings withQuoteAllText(Object quoteAllText) {
        this.quoteAllText = quoteAllText;
        return this;
    }

    /**
     * Get the fileExtension property: The file extension used to create the files. Type: string (or Expression with
     * resultType string).
     * 
     * @return the fileExtension value.
     */
    public Object fileExtension() {
        return this.fileExtension;
    }

    /**
     * Set the fileExtension property: The file extension used to create the files. Type: string (or Expression with
     * resultType string).
     * 
     * @param fileExtension the fileExtension value to set.
     * @return the DelimitedTextWriteSettings object itself.
     */
    public DelimitedTextWriteSettings withFileExtension(Object fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    /**
     * Get the maxRowsPerFile property: Limit the written file's row count to be smaller than or equal to the specified
     * count. Type: integer (or Expression with resultType integer).
     * 
     * @return the maxRowsPerFile value.
     */
    public Object maxRowsPerFile() {
        return this.maxRowsPerFile;
    }

    /**
     * Set the maxRowsPerFile property: Limit the written file's row count to be smaller than or equal to the specified
     * count. Type: integer (or Expression with resultType integer).
     * 
     * @param maxRowsPerFile the maxRowsPerFile value to set.
     * @return the DelimitedTextWriteSettings object itself.
     */
    public DelimitedTextWriteSettings withMaxRowsPerFile(Object maxRowsPerFile) {
        this.maxRowsPerFile = maxRowsPerFile;
        return this;
    }

    /**
     * Get the fileNamePrefix property: Specifies the file name pattern
     * &lt;fileNamePrefix&gt;_&lt;fileIndex&gt;.&lt;fileExtension&gt; when copy from non-file based store without
     * partitionOptions. Type: string (or Expression with resultType string).
     * 
     * @return the fileNamePrefix value.
     */
    public Object fileNamePrefix() {
        return this.fileNamePrefix;
    }

    /**
     * Set the fileNamePrefix property: Specifies the file name pattern
     * &lt;fileNamePrefix&gt;_&lt;fileIndex&gt;.&lt;fileExtension&gt; when copy from non-file based store without
     * partitionOptions. Type: string (or Expression with resultType string).
     * 
     * @param fileNamePrefix the fileNamePrefix value to set.
     * @return the DelimitedTextWriteSettings object itself.
     */
    public DelimitedTextWriteSettings withFileNamePrefix(Object fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (fileExtension() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property fileExtension in model DelimitedTextWriteSettings"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DelimitedTextWriteSettings.class);
}
