// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Distcp settings.
 */
@Fluent
public final class DistcpSettings {
    /*
     * Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "resourceManagerEndpoint", required = true)
    private Object resourceManagerEndpoint;

    /*
     * Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tempScriptPath", required = true)
    private Object tempScriptPath;

    /*
     * Specifies the Distcp options. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "distcpOptions")
    private Object distcpOptions;

    /**
     * Creates an instance of DistcpSettings class.
     */
    public DistcpSettings() {
    }

    /**
     * Get the resourceManagerEndpoint property: Specifies the Yarn ResourceManager endpoint. Type: string (or
     * Expression with resultType string).
     * 
     * @return the resourceManagerEndpoint value.
     */
    public Object resourceManagerEndpoint() {
        return this.resourceManagerEndpoint;
    }

    /**
     * Set the resourceManagerEndpoint property: Specifies the Yarn ResourceManager endpoint. Type: string (or
     * Expression with resultType string).
     * 
     * @param resourceManagerEndpoint the resourceManagerEndpoint value to set.
     * @return the DistcpSettings object itself.
     */
    public DistcpSettings withResourceManagerEndpoint(Object resourceManagerEndpoint) {
        this.resourceManagerEndpoint = resourceManagerEndpoint;
        return this;
    }

    /**
     * Get the tempScriptPath property: Specifies an existing folder path which will be used to store temp Distcp
     * command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or
     * Expression with resultType string).
     * 
     * @return the tempScriptPath value.
     */
    public Object tempScriptPath() {
        return this.tempScriptPath;
    }

    /**
     * Set the tempScriptPath property: Specifies an existing folder path which will be used to store temp Distcp
     * command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or
     * Expression with resultType string).
     * 
     * @param tempScriptPath the tempScriptPath value to set.
     * @return the DistcpSettings object itself.
     */
    public DistcpSettings withTempScriptPath(Object tempScriptPath) {
        this.tempScriptPath = tempScriptPath;
        return this;
    }

    /**
     * Get the distcpOptions property: Specifies the Distcp options. Type: string (or Expression with resultType
     * string).
     * 
     * @return the distcpOptions value.
     */
    public Object distcpOptions() {
        return this.distcpOptions;
    }

    /**
     * Set the distcpOptions property: Specifies the Distcp options. Type: string (or Expression with resultType
     * string).
     * 
     * @param distcpOptions the distcpOptions value to set.
     * @return the DistcpSettings object itself.
     */
    public DistcpSettings withDistcpOptions(Object distcpOptions) {
        this.distcpOptions = distcpOptions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceManagerEndpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property resourceManagerEndpoint in model DistcpSettings"));
        }
        if (tempScriptPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property tempScriptPath in model DistcpSettings"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DistcpSettings.class);
}
