// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.DocumentDbCollectionDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Microsoft Azure Document Database Collection dataset.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = DocumentDbCollectionDataset.class,
    visible = true)
@JsonTypeName("DocumentDbCollection")
@Fluent
public final class DocumentDbCollectionDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "DocumentDbCollection";

    /*
     * DocumentDB Collection dataset properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private DocumentDbCollectionDatasetTypeProperties innerTypeProperties
        = new DocumentDbCollectionDatasetTypeProperties();

    /**
     * Creates an instance of DocumentDbCollectionDataset class.
     */
    public DocumentDbCollectionDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: DocumentDB Collection dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private DocumentDbCollectionDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentDbCollectionDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the collectionName property: Document Database collection name. Type: string (or Expression with resultType
     * string).
     * 
     * @return the collectionName value.
     */
    public Object collectionName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().collectionName();
    }

    /**
     * Set the collectionName property: Document Database collection name. Type: string (or Expression with resultType
     * string).
     * 
     * @param collectionName the collectionName value to set.
     * @return the DocumentDbCollectionDataset object itself.
     */
    public DocumentDbCollectionDataset withCollectionName(Object collectionName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DocumentDbCollectionDatasetTypeProperties();
        }
        this.innerTypeProperties().withCollectionName(collectionName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model DocumentDbCollectionDataset"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DocumentDbCollectionDataset.class);
}
