// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.ExcelDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Excel dataset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ExcelDataset.class, visible = true)
@JsonTypeName("Excel")
@Fluent
public final class ExcelDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Excel";

    /*
     * Excel dataset properties.
     */
    @JsonProperty(value = "typeProperties")
    private ExcelDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of ExcelDataset class.
     */
    public ExcelDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Excel dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ExcelDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExcelDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the location property: The location of the excel storage.
     * 
     * @return the location value.
     */
    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    /**
     * Set the location property: The location of the excel storage.
     * 
     * @param location the location value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    /**
     * Get the sheetName property: The sheet name of excel file. Type: string (or Expression with resultType string).
     * 
     * @return the sheetName value.
     */
    public Object sheetName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sheetName();
    }

    /**
     * Set the sheetName property: The sheet name of excel file. Type: string (or Expression with resultType string).
     * 
     * @param sheetName the sheetName value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withSheetName(Object sheetName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withSheetName(sheetName);
        return this;
    }

    /**
     * Get the sheetIndex property: The sheet index of excel file and default value is 0. Type: integer (or Expression
     * with resultType integer).
     * 
     * @return the sheetIndex value.
     */
    public Object sheetIndex() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sheetIndex();
    }

    /**
     * Set the sheetIndex property: The sheet index of excel file and default value is 0. Type: integer (or Expression
     * with resultType integer).
     * 
     * @param sheetIndex the sheetIndex value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withSheetIndex(Object sheetIndex) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withSheetIndex(sheetIndex);
        return this;
    }

    /**
     * Get the range property: The partial data of one sheet. Type: string (or Expression with resultType string).
     * 
     * @return the range value.
     */
    public Object range() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().range();
    }

    /**
     * Set the range property: The partial data of one sheet. Type: string (or Expression with resultType string).
     * 
     * @param range the range value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withRange(Object range) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withRange(range);
        return this;
    }

    /**
     * Get the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @return the firstRowAsHeader value.
     */
    public Object firstRowAsHeader() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().firstRowAsHeader();
    }

    /**
     * Set the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @param firstRowAsHeader the firstRowAsHeader value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withFirstRowAsHeader(Object firstRowAsHeader) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withFirstRowAsHeader(firstRowAsHeader);
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the json dataset.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    /**
     * Set the compression property: The data compression method used for the json dataset.
     * 
     * @param compression the compression value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    /**
     * Get the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @return the nullValue value.
     */
    public Object nullValue() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nullValue();
    }

    /**
     * Set the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @param nullValue the nullValue value to set.
     * @return the ExcelDataset object itself.
     */
    public ExcelDataset withNullValue(Object nullValue) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withNullValue(nullValue);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
