// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * Execution policy for an execute pipeline activity.
 */
@Fluent
public final class ExecutePipelineActivityPolicy {
    /*
     * When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JsonProperty(value = "secureInput")
    private Boolean secureInput;

    /*
     * Execution policy for an execute pipeline activity.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ExecutePipelineActivityPolicy class.
     */
    public ExecutePipelineActivityPolicy() {
    }

    /**
     * Get the secureInput property: When set to true, Input from activity is considered as secure and will not be
     * logged to monitoring.
     * 
     * @return the secureInput value.
     */
    public Boolean secureInput() {
        return this.secureInput;
    }

    /**
     * Set the secureInput property: When set to true, Input from activity is considered as secure and will not be
     * logged to monitoring.
     * 
     * @param secureInput the secureInput value to set.
     * @return the ExecutePipelineActivityPolicy object itself.
     */
    public ExecutePipelineActivityPolicy withSecureInput(Boolean secureInput) {
        this.secureInput = secureInput;
        return this;
    }

    /**
     * Get the additionalProperties property: Execution policy for an execute pipeline activity.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Execution policy for an execute pipeline activity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ExecutePipelineActivityPolicy object itself.
     */
    public ExecutePipelineActivityPolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
