// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Nested representation of a complex expression.
 */
@Fluent
public final class ExpressionV2 {
    /*
     * Type of expressions supported by the system. Type: string.
     */
    @JsonProperty(value = "type")
    private ExpressionV2Type type;

    /*
     * Value for Constant/Field Type: string.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * Expression operator value Type: string.
     */
    @JsonProperty(value = "operator")
    private String operator;

    /*
     * List of nested expressions.
     */
    @JsonProperty(value = "operands")
    private List<ExpressionV2> operands;

    /**
     * Creates an instance of ExpressionV2 class.
     */
    public ExpressionV2() {
    }

    /**
     * Get the type property: Type of expressions supported by the system. Type: string.
     * 
     * @return the type value.
     */
    public ExpressionV2Type type() {
        return this.type;
    }

    /**
     * Set the type property: Type of expressions supported by the system. Type: string.
     * 
     * @param type the type value to set.
     * @return the ExpressionV2 object itself.
     */
    public ExpressionV2 withType(ExpressionV2Type type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: Value for Constant/Field Type: string.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value for Constant/Field Type: string.
     * 
     * @param value the value value to set.
     * @return the ExpressionV2 object itself.
     */
    public ExpressionV2 withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the operator property: Expression operator value Type: string.
     * 
     * @return the operator value.
     */
    public String operator() {
        return this.operator;
    }

    /**
     * Set the operator property: Expression operator value Type: string.
     * 
     * @param operator the operator value to set.
     * @return the ExpressionV2 object itself.
     */
    public ExpressionV2 withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the operands property: List of nested expressions.
     * 
     * @return the operands value.
     */
    public List<ExpressionV2> operands() {
        return this.operands;
    }

    /**
     * Set the operands property: List of nested expressions.
     * 
     * @param operands the operands value to set.
     * @return the ExpressionV2 object itself.
     */
    public ExpressionV2 withOperands(List<ExpressionV2> operands) {
        this.operands = operands;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operands() != null) {
            operands().forEach(e -> e.validate());
        }
    }
}
