// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.UUID;

/**
 * Identity properties of the factory resource.
 */
@Fluent
public final class FactoryIdentity {
    /*
     * The identity type.
     */
    @JsonProperty(value = "type", required = true)
    private FactoryIdentityType type;

    /*
     * The principal id of the identity.
     */
    @JsonProperty(value = "principalId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID principalId;

    /*
     * The client tenant id of the identity.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID tenantId;

    /*
     * List of user assigned identities for the factory.
     */
    @JsonProperty(value = "userAssignedIdentities")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> userAssignedIdentities;

    /**
     * Creates an instance of FactoryIdentity class.
     */
    public FactoryIdentity() {
    }

    /**
     * Get the type property: The identity type.
     * 
     * @return the type value.
     */
    public FactoryIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The identity type.
     * 
     * @param type the type value to set.
     * @return the FactoryIdentity object itself.
     */
    public FactoryIdentity withType(FactoryIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the principalId property: The principal id of the identity.
     * 
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The client tenant id of the identity.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Get the userAssignedIdentities property: List of user assigned identities for the factory.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, Object> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: List of user assigned identities for the factory.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the FactoryIdentity object itself.
     */
    public FactoryIdentity withUserAssignedIdentities(Map<String, Object> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model FactoryIdentity"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FactoryIdentity.class);
}
