// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Factory's git repo information.
 */
@Fluent
public final class FactoryRepoUpdate {
    /*
     * The factory resource id.
     */
    @JsonProperty(value = "factoryResourceId")
    private String factoryResourceId;

    /*
     * Git repo information of the factory.
     */
    @JsonProperty(value = "repoConfiguration")
    private FactoryRepoConfiguration repoConfiguration;

    /**
     * Creates an instance of FactoryRepoUpdate class.
     */
    public FactoryRepoUpdate() {
    }

    /**
     * Get the factoryResourceId property: The factory resource id.
     * 
     * @return the factoryResourceId value.
     */
    public String factoryResourceId() {
        return this.factoryResourceId;
    }

    /**
     * Set the factoryResourceId property: The factory resource id.
     * 
     * @param factoryResourceId the factoryResourceId value to set.
     * @return the FactoryRepoUpdate object itself.
     */
    public FactoryRepoUpdate withFactoryResourceId(String factoryResourceId) {
        this.factoryResourceId = factoryResourceId;
        return this;
    }

    /**
     * Get the repoConfiguration property: Git repo information of the factory.
     * 
     * @return the repoConfiguration value.
     */
    public FactoryRepoConfiguration repoConfiguration() {
        return this.repoConfiguration;
    }

    /**
     * Set the repoConfiguration property: Git repo information of the factory.
     * 
     * @param repoConfiguration the repoConfiguration value to set.
     * @return the FactoryRepoUpdate object itself.
     */
    public FactoryRepoUpdate withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        this.repoConfiguration = repoConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (repoConfiguration() != null) {
            repoConfiguration().validate();
        }
    }
}
