// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ForEachActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * This activity is used for iterating over a collection and execute given activities.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ForEachActivity.class, visible = true)
@JsonTypeName("ForEach")
@Fluent
public final class ForEachActivity extends ControlActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "ForEach";

    /*
     * ForEach activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ForEachActivityTypeProperties innerTypeProperties = new ForEachActivityTypeProperties();

    /**
     * Creates an instance of ForEachActivity class.
     */
    public ForEachActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: ForEach activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ForEachActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ForEachActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ForEachActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ForEachActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ForEachActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ForEachActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ForEachActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the isSequential property: Should the loop be executed in sequence or in parallel (max 50).
     * 
     * @return the isSequential value.
     */
    public Boolean isSequential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().isSequential();
    }

    /**
     * Set the isSequential property: Should the loop be executed in sequence or in parallel (max 50).
     * 
     * @param isSequential the isSequential value to set.
     * @return the ForEachActivity object itself.
     */
    public ForEachActivity withIsSequential(Boolean isSequential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withIsSequential(isSequential);
        return this;
    }

    /**
     * Get the batchCount property: Batch count to be used for controlling the number of parallel execution (when
     * isSequential is set to false).
     * 
     * @return the batchCount value.
     */
    public Integer batchCount() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().batchCount();
    }

    /**
     * Set the batchCount property: Batch count to be used for controlling the number of parallel execution (when
     * isSequential is set to false).
     * 
     * @param batchCount the batchCount value to set.
     * @return the ForEachActivity object itself.
     */
    public ForEachActivity withBatchCount(Integer batchCount) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withBatchCount(batchCount);
        return this;
    }

    /**
     * Get the items property: Collection to iterate.
     * 
     * @return the items value.
     */
    public Expression items() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().items();
    }

    /**
     * Set the items property: Collection to iterate.
     * 
     * @param items the items value to set.
     * @return the ForEachActivity object itself.
     */
    public ForEachActivity withItems(Expression items) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withItems(items);
        return this;
    }

    /**
     * Get the activities property: List of activities to execute .
     * 
     * @return the activities value.
     */
    public List<Activity> activities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().activities();
    }

    /**
     * Set the activities property: List of activities to execute .
     * 
     * @param activities the activities value to set.
     * @return the ForEachActivity object itself.
     */
    public ForEachActivity withActivities(List<Activity> activities) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withActivities(activities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ForEachActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ForEachActivity.class);
}
