// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The authentication type to be used to connect to the FTP server.
 */
public final class FtpAuthenticationType extends ExpandableStringEnum<FtpAuthenticationType> {
    /**
     * Static value Basic for FtpAuthenticationType.
     */
    public static final FtpAuthenticationType BASIC = fromString("Basic");

    /**
     * Static value Anonymous for FtpAuthenticationType.
     */
    public static final FtpAuthenticationType ANONYMOUS = fromString("Anonymous");

    /**
     * Creates a new instance of FtpAuthenticationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FtpAuthenticationType() {
    }

    /**
     * Creates or finds a FtpAuthenticationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding FtpAuthenticationType.
     */
    @JsonCreator
    public static FtpAuthenticationType fromString(String name) {
        return fromString(name, FtpAuthenticationType.class);
    }

    /**
     * Gets known FtpAuthenticationType values.
     * 
     * @return known FtpAuthenticationType values.
     */
    public static Collection<FtpAuthenticationType> values() {
        return values(FtpAuthenticationType.class);
    }
}
