// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.GetMetadataActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Activity to get metadata of dataset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = GetMetadataActivity.class, visible = true)
@JsonTypeName("GetMetadata")
@Fluent
public final class GetMetadataActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "GetMetadata";

    /*
     * GetMetadata activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private GetMetadataActivityTypeProperties innerTypeProperties = new GetMetadataActivityTypeProperties();

    /**
     * Creates an instance of GetMetadataActivity class.
     */
    public GetMetadataActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: GetMetadata activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private GetMetadataActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GetMetadataActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the dataset property: GetMetadata activity dataset reference.
     * 
     * @return the dataset value.
     */
    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    /**
     * Set the dataset property: GetMetadata activity dataset reference.
     * 
     * @param dataset the dataset value to set.
     * @return the GetMetadataActivity object itself.
     */
    public GetMetadataActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    /**
     * Get the fieldList property: Fields of metadata to get from dataset.
     * 
     * @return the fieldList value.
     */
    public List<Object> fieldList() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fieldList();
    }

    /**
     * Set the fieldList property: Fields of metadata to get from dataset.
     * 
     * @param fieldList the fieldList value to set.
     * @return the GetMetadataActivity object itself.
     */
    public GetMetadataActivity withFieldList(List<Object> fieldList) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withFieldList(fieldList);
        return this;
    }

    /**
     * Get the storeSettings property: GetMetadata activity store settings.
     * 
     * @return the storeSettings value.
     */
    public StoreReadSettings storeSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storeSettings();
    }

    /**
     * Set the storeSettings property: GetMetadata activity store settings.
     * 
     * @param storeSettings the storeSettings value to set.
     * @return the GetMetadataActivity object itself.
     */
    public GetMetadataActivity withStoreSettings(StoreReadSettings storeSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withStoreSettings(storeSettings);
        return this;
    }

    /**
     * Get the formatSettings property: GetMetadata activity format settings.
     * 
     * @return the formatSettings value.
     */
    public FormatReadSettings formatSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().formatSettings();
    }

    /**
     * Set the formatSettings property: GetMetadata activity format settings.
     * 
     * @param formatSettings the formatSettings value to set.
     * @return the GetMetadataActivity object itself.
     */
    public GetMetadataActivity withFormatSettings(FormatReadSettings formatSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withFormatSettings(formatSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model GetMetadataActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GetMetadataActivity.class);
}
