// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Get GitHub access token request definition.
 */
@Fluent
public final class GitHubAccessTokenRequest {
    /*
     * GitHub access code.
     */
    @JsonProperty(value = "gitHubAccessCode", required = true)
    private String gitHubAccessCode;

    /*
     * GitHub application client ID.
     */
    @JsonProperty(value = "gitHubClientId")
    private String gitHubClientId;

    /*
     * GitHub bring your own app client secret information.
     */
    @JsonProperty(value = "gitHubClientSecret")
    private GitHubClientSecret gitHubClientSecret;

    /*
     * GitHub access token base URL.
     */
    @JsonProperty(value = "gitHubAccessTokenBaseUrl", required = true)
    private String gitHubAccessTokenBaseUrl;

    /**
     * Creates an instance of GitHubAccessTokenRequest class.
     */
    public GitHubAccessTokenRequest() {
    }

    /**
     * Get the gitHubAccessCode property: GitHub access code.
     * 
     * @return the gitHubAccessCode value.
     */
    public String gitHubAccessCode() {
        return this.gitHubAccessCode;
    }

    /**
     * Set the gitHubAccessCode property: GitHub access code.
     * 
     * @param gitHubAccessCode the gitHubAccessCode value to set.
     * @return the GitHubAccessTokenRequest object itself.
     */
    public GitHubAccessTokenRequest withGitHubAccessCode(String gitHubAccessCode) {
        this.gitHubAccessCode = gitHubAccessCode;
        return this;
    }

    /**
     * Get the gitHubClientId property: GitHub application client ID.
     * 
     * @return the gitHubClientId value.
     */
    public String gitHubClientId() {
        return this.gitHubClientId;
    }

    /**
     * Set the gitHubClientId property: GitHub application client ID.
     * 
     * @param gitHubClientId the gitHubClientId value to set.
     * @return the GitHubAccessTokenRequest object itself.
     */
    public GitHubAccessTokenRequest withGitHubClientId(String gitHubClientId) {
        this.gitHubClientId = gitHubClientId;
        return this;
    }

    /**
     * Get the gitHubClientSecret property: GitHub bring your own app client secret information.
     * 
     * @return the gitHubClientSecret value.
     */
    public GitHubClientSecret gitHubClientSecret() {
        return this.gitHubClientSecret;
    }

    /**
     * Set the gitHubClientSecret property: GitHub bring your own app client secret information.
     * 
     * @param gitHubClientSecret the gitHubClientSecret value to set.
     * @return the GitHubAccessTokenRequest object itself.
     */
    public GitHubAccessTokenRequest withGitHubClientSecret(GitHubClientSecret gitHubClientSecret) {
        this.gitHubClientSecret = gitHubClientSecret;
        return this;
    }

    /**
     * Get the gitHubAccessTokenBaseUrl property: GitHub access token base URL.
     * 
     * @return the gitHubAccessTokenBaseUrl value.
     */
    public String gitHubAccessTokenBaseUrl() {
        return this.gitHubAccessTokenBaseUrl;
    }

    /**
     * Set the gitHubAccessTokenBaseUrl property: GitHub access token base URL.
     * 
     * @param gitHubAccessTokenBaseUrl the gitHubAccessTokenBaseUrl value to set.
     * @return the GitHubAccessTokenRequest object itself.
     */
    public GitHubAccessTokenRequest withGitHubAccessTokenBaseUrl(String gitHubAccessTokenBaseUrl) {
        this.gitHubAccessTokenBaseUrl = gitHubAccessTokenBaseUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitHubAccessCode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property gitHubAccessCode in model GitHubAccessTokenRequest"));
        }
        if (gitHubClientSecret() != null) {
            gitHubClientSecret().validate();
        }
        if (gitHubAccessTokenBaseUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property gitHubAccessTokenBaseUrl in model GitHubAccessTokenRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GitHubAccessTokenRequest.class);
}
