// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Client secret information for factory's bring your own app repository configuration.
 */
@Fluent
public final class GitHubClientSecret {
    /*
     * Bring your own app client secret AKV URL.
     */
    @JsonProperty(value = "byoaSecretAkvUrl")
    private String byoaSecretAkvUrl;

    /*
     * Bring your own app client secret name in AKV.
     */
    @JsonProperty(value = "byoaSecretName")
    private String byoaSecretName;

    /**
     * Creates an instance of GitHubClientSecret class.
     */
    public GitHubClientSecret() {
    }

    /**
     * Get the byoaSecretAkvUrl property: Bring your own app client secret AKV URL.
     * 
     * @return the byoaSecretAkvUrl value.
     */
    public String byoaSecretAkvUrl() {
        return this.byoaSecretAkvUrl;
    }

    /**
     * Set the byoaSecretAkvUrl property: Bring your own app client secret AKV URL.
     * 
     * @param byoaSecretAkvUrl the byoaSecretAkvUrl value to set.
     * @return the GitHubClientSecret object itself.
     */
    public GitHubClientSecret withByoaSecretAkvUrl(String byoaSecretAkvUrl) {
        this.byoaSecretAkvUrl = byoaSecretAkvUrl;
        return this;
    }

    /**
     * Get the byoaSecretName property: Bring your own app client secret name in AKV.
     * 
     * @return the byoaSecretName value.
     */
    public String byoaSecretName() {
        return this.byoaSecretName;
    }

    /**
     * Set the byoaSecretName property: Bring your own app client secret name in AKV.
     * 
     * @param byoaSecretName the byoaSecretName value to set.
     * @return the GitHubClientSecret object itself.
     */
    public GitHubClientSecret withByoaSecretName(String byoaSecretName) {
        this.byoaSecretName = byoaSecretName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
