// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.GoogleAdWordsLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Google AdWords service linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = GoogleAdWordsLinkedService.class,
    visible = true)
@JsonTypeName("GoogleAdWords")
@Fluent
public final class GoogleAdWordsLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "GoogleAdWords";

    /*
     * Google AdWords service linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private GoogleAdWordsLinkedServiceTypeProperties innerTypeProperties
        = new GoogleAdWordsLinkedServiceTypeProperties();

    /**
     * Creates an instance of GoogleAdWordsLinkedService class.
     */
    public GoogleAdWordsLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Google AdWords service linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private GoogleAdWordsLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleAdWordsLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleAdWordsLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleAdWordsLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleAdWordsLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the connectionProperties property: (Deprecated) Properties used to connect to GoogleAds. It is mutually
     * exclusive with any other properties in the linked service. Type: object.
     * 
     * @return the connectionProperties value.
     */
    public Object connectionProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionProperties();
    }

    /**
     * Set the connectionProperties property: (Deprecated) Properties used to connect to GoogleAds. It is mutually
     * exclusive with any other properties in the linked service. Type: object.
     * 
     * @param connectionProperties the connectionProperties value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withConnectionProperties(Object connectionProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionProperties(connectionProperties);
        return this;
    }

    /**
     * Get the clientCustomerId property: The Client customer ID of the AdWords account that you want to fetch report
     * data for. Type: string (or Expression with resultType string).
     * 
     * @return the clientCustomerId value.
     */
    public Object clientCustomerId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientCustomerId();
    }

    /**
     * Set the clientCustomerId property: The Client customer ID of the AdWords account that you want to fetch report
     * data for. Type: string (or Expression with resultType string).
     * 
     * @param clientCustomerId the clientCustomerId value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withClientCustomerId(Object clientCustomerId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientCustomerId(clientCustomerId);
        return this;
    }

    /**
     * Get the developerToken property: The developer token associated with the manager account that you use to grant
     * access to the AdWords API.
     * 
     * @return the developerToken value.
     */
    public SecretBase developerToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().developerToken();
    }

    /**
     * Set the developerToken property: The developer token associated with the manager account that you use to grant
     * access to the AdWords API.
     * 
     * @param developerToken the developerToken value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withDeveloperToken(SecretBase developerToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDeveloperToken(developerToken);
        return this;
    }

    /**
     * Get the authenticationType property: The OAuth 2.0 authentication mechanism used for authentication.
     * ServiceAuthentication can only be used on self-hosted IR.
     * 
     * @return the authenticationType value.
     */
    public GoogleAdWordsAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: The OAuth 2.0 authentication mechanism used for authentication.
     * ServiceAuthentication can only be used on self-hosted IR.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withAuthenticationType(GoogleAdWordsAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the refreshToken property: The refresh token obtained from Google for authorizing access to AdWords for
     * UserAuthentication.
     * 
     * @return the refreshToken value.
     */
    public SecretBase refreshToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().refreshToken();
    }

    /**
     * Set the refreshToken property: The refresh token obtained from Google for authorizing access to AdWords for
     * UserAuthentication.
     * 
     * @param refreshToken the refreshToken value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withRefreshToken(SecretBase refreshToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withRefreshToken(refreshToken);
        return this;
    }

    /**
     * Get the clientId property: The client id of the google application used to acquire the refresh token. Type:
     * string (or Expression with resultType string).
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    /**
     * Set the clientId property: The client id of the google application used to acquire the refresh token. Type:
     * string (or Expression with resultType string).
     * 
     * @param clientId the clientId value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    /**
     * Get the clientSecret property: The client secret of the google application used to acquire the refresh token.
     * 
     * @return the clientSecret value.
     */
    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    /**
     * Set the clientSecret property: The client secret of the google application used to acquire the refresh token.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    /**
     * Get the email property: The service account email ID that is used for ServiceAuthentication and can only be used
     * on self-hosted IR. Type: string (or Expression with resultType string).
     * 
     * @return the email value.
     */
    public Object email() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().email();
    }

    /**
     * Set the email property: The service account email ID that is used for ServiceAuthentication and can only be used
     * on self-hosted IR. Type: string (or Expression with resultType string).
     * 
     * @param email the email value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withEmail(Object email) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEmail(email);
        return this;
    }

    /**
     * Get the keyFilePath property: (Deprecated) The full path to the .p12 key file that is used to authenticate the
     * service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType
     * string).
     * 
     * @return the keyFilePath value.
     */
    public Object keyFilePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().keyFilePath();
    }

    /**
     * Set the keyFilePath property: (Deprecated) The full path to the .p12 key file that is used to authenticate the
     * service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType
     * string).
     * 
     * @param keyFilePath the keyFilePath value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withKeyFilePath(Object keyFilePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withKeyFilePath(keyFilePath);
        return this;
    }

    /**
     * Get the trustedCertPath property: (Deprecated) The full path of the .pem file containing trusted CA certificates
     * for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted
     * IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType
     * string).
     * 
     * @return the trustedCertPath value.
     */
    public Object trustedCertPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustedCertPath();
    }

    /**
     * Set the trustedCertPath property: (Deprecated) The full path of the .pem file containing trusted CA certificates
     * for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted
     * IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType
     * string).
     * 
     * @param trustedCertPath the trustedCertPath value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withTrustedCertPath(Object trustedCertPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustedCertPath(trustedCertPath);
        return this;
    }

    /**
     * Get the useSystemTrustStore property: (Deprecated) Specifies whether to use a CA certificate from the system
     * trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with
     * resultType boolean).
     * 
     * @return the useSystemTrustStore value.
     */
    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    /**
     * Set the useSystemTrustStore property: (Deprecated) Specifies whether to use a CA certificate from the system
     * trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with
     * resultType boolean).
     * 
     * @param useSystemTrustStore the useSystemTrustStore value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    /**
     * Get the privateKey property: The private key that is used to authenticate the service account email address and
     * can only be used on self-hosted IR.
     * 
     * @return the privateKey value.
     */
    public SecretBase privateKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKey();
    }

    /**
     * Set the privateKey property: The private key that is used to authenticate the service account email address and
     * can only be used on self-hosted IR.
     * 
     * @param privateKey the privateKey value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withPrivateKey(SecretBase privateKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKey(privateKey);
        return this;
    }

    /**
     * Get the loginCustomerId property: The customer ID of the Google Ads Manager account through which you want to
     * fetch report data of specific Customer. Type: string (or Expression with resultType string).
     * 
     * @return the loginCustomerId value.
     */
    public Object loginCustomerId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loginCustomerId();
    }

    /**
     * Set the loginCustomerId property: The customer ID of the Google Ads Manager account through which you want to
     * fetch report data of specific Customer. Type: string (or Expression with resultType string).
     * 
     * @param loginCustomerId the loginCustomerId value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withLoginCustomerId(Object loginCustomerId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLoginCustomerId(loginCustomerId);
        return this;
    }

    /**
     * Get the googleAdsApiVersion property: The Google Ads API major version such as v14. The supported major versions
     * could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression
     * with resultType string).
     * 
     * @return the googleAdsApiVersion value.
     */
    public Object googleAdsApiVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().googleAdsApiVersion();
    }

    /**
     * Set the googleAdsApiVersion property: The Google Ads API major version such as v14. The supported major versions
     * could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression
     * with resultType string).
     * 
     * @param googleAdsApiVersion the googleAdsApiVersion value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withGoogleAdsApiVersion(Object googleAdsApiVersion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withGoogleAdsApiVersion(googleAdsApiVersion);
        return this;
    }

    /**
     * Get the supportLegacyDataTypes property: Specifies whether to use the legacy data type mappings, which maps
     * float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward
     * compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the supportLegacyDataTypes value.
     */
    public Object supportLegacyDataTypes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().supportLegacyDataTypes();
    }

    /**
     * Set the supportLegacyDataTypes property: Specifies whether to use the legacy data type mappings, which maps
     * float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward
     * compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     * 
     * @param supportLegacyDataTypes the supportLegacyDataTypes value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withSupportLegacyDataTypes(Object supportLegacyDataTypes) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSupportLegacyDataTypes(supportLegacyDataTypes);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the GoogleAdWordsLinkedService object itself.
     */
    public GoogleAdWordsLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model GoogleAdWordsLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GoogleAdWordsLinkedService.class);
}
