// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.GoogleBigQueryV2LinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Google BigQuery service linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = GoogleBigQueryV2LinkedService.class,
    visible = true)
@JsonTypeName("GoogleBigQueryV2")
@Fluent
public final class GoogleBigQueryV2LinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "GoogleBigQueryV2";

    /*
     * Google BigQuery service linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private GoogleBigQueryV2LinkedServiceTypeProperties innerTypeProperties
        = new GoogleBigQueryV2LinkedServiceTypeProperties();

    /**
     * Creates an instance of GoogleBigQueryV2LinkedService class.
     */
    public GoogleBigQueryV2LinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Google BigQuery service linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private GoogleBigQueryV2LinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleBigQueryV2LinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleBigQueryV2LinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleBigQueryV2LinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GoogleBigQueryV2LinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the projectId property: The default BigQuery project id to query against. Type: string (or Expression with
     * resultType string).
     * 
     * @return the projectId value.
     */
    public Object projectId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().projectId();
    }

    /**
     * Set the projectId property: The default BigQuery project id to query against. Type: string (or Expression with
     * resultType string).
     * 
     * @param projectId the projectId value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withProjectId(Object projectId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withProjectId(projectId);
        return this;
    }

    /**
     * Get the authenticationType property: The OAuth 2.0 authentication mechanism used for authentication.
     * 
     * @return the authenticationType value.
     */
    public GoogleBigQueryV2AuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: The OAuth 2.0 authentication mechanism used for authentication.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withAuthenticationType(GoogleBigQueryV2AuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the clientId property: The client id of the google application used to acquire the refresh token. Type:
     * string (or Expression with resultType string).
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    /**
     * Set the clientId property: The client id of the google application used to acquire the refresh token. Type:
     * string (or Expression with resultType string).
     * 
     * @param clientId the clientId value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    /**
     * Get the clientSecret property: The client secret of the google application used to acquire the refresh token.
     * 
     * @return the clientSecret value.
     */
    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    /**
     * Set the clientSecret property: The client secret of the google application used to acquire the refresh token.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    /**
     * Get the refreshToken property: The refresh token obtained from Google for authorizing access to BigQuery for
     * UserAuthentication.
     * 
     * @return the refreshToken value.
     */
    public SecretBase refreshToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().refreshToken();
    }

    /**
     * Set the refreshToken property: The refresh token obtained from Google for authorizing access to BigQuery for
     * UserAuthentication.
     * 
     * @param refreshToken the refreshToken value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withRefreshToken(SecretBase refreshToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withRefreshToken(refreshToken);
        return this;
    }

    /**
     * Get the keyFileContent property: The content of the .json key file that is used to authenticate the service
     * account. Type: string (or Expression with resultType string).
     * 
     * @return the keyFileContent value.
     */
    public SecretBase keyFileContent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().keyFileContent();
    }

    /**
     * Set the keyFileContent property: The content of the .json key file that is used to authenticate the service
     * account. Type: string (or Expression with resultType string).
     * 
     * @param keyFileContent the keyFileContent value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withKeyFileContent(SecretBase keyFileContent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withKeyFileContent(keyFileContent);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the GoogleBigQueryV2LinkedService object itself.
     */
    public GoogleBigQueryV2LinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model GoogleBigQueryV2LinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GoogleBigQueryV2LinkedService.class);
}
