// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightStreamingActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * HDInsight streaming activity type.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = HDInsightStreamingActivity.class,
    visible = true)
@JsonTypeName("HDInsightStreaming")
@Fluent
public final class HDInsightStreamingActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "HDInsightStreaming";

    /*
     * HDInsight streaming activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private HDInsightStreamingActivityTypeProperties innerTypeProperties
        = new HDInsightStreamingActivityTypeProperties();

    /**
     * Creates an instance of HDInsightStreamingActivity class.
     */
    public HDInsightStreamingActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: HDInsight streaming activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private HDInsightStreamingActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HDInsightStreamingActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the storageLinkedServices property: Storage linked service references.
     * 
     * @return the storageLinkedServices value.
     */
    public List<LinkedServiceReference> storageLinkedServices() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storageLinkedServices();
    }

    /**
     * Set the storageLinkedServices property: Storage linked service references.
     * 
     * @param storageLinkedServices the storageLinkedServices value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withStorageLinkedServices(storageLinkedServices);
        return this;
    }

    /**
     * Get the arguments property: User specified arguments to HDInsightActivity.
     * 
     * @return the arguments value.
     */
    public List<Object> arguments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().arguments();
    }

    /**
     * Set the arguments property: User specified arguments to HDInsightActivity.
     * 
     * @param arguments the arguments value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withArguments(List<Object> arguments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withArguments(arguments);
        return this;
    }

    /**
     * Get the getDebugInfo property: Debug info option.
     * 
     * @return the getDebugInfo value.
     */
    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().getDebugInfo();
    }

    /**
     * Set the getDebugInfo property: Debug info option.
     * 
     * @param getDebugInfo the getDebugInfo value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withGetDebugInfo(getDebugInfo);
        return this;
    }

    /**
     * Get the mapper property: Mapper executable name. Type: string (or Expression with resultType string).
     * 
     * @return the mapper value.
     */
    public Object mapper() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mapper();
    }

    /**
     * Set the mapper property: Mapper executable name. Type: string (or Expression with resultType string).
     * 
     * @param mapper the mapper value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withMapper(Object mapper) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withMapper(mapper);
        return this;
    }

    /**
     * Get the reducer property: Reducer executable name. Type: string (or Expression with resultType string).
     * 
     * @return the reducer value.
     */
    public Object reducer() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().reducer();
    }

    /**
     * Set the reducer property: Reducer executable name. Type: string (or Expression with resultType string).
     * 
     * @param reducer the reducer value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withReducer(Object reducer) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withReducer(reducer);
        return this;
    }

    /**
     * Get the input property: Input blob path. Type: string (or Expression with resultType string).
     * 
     * @return the input value.
     */
    public Object input() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().input();
    }

    /**
     * Set the input property: Input blob path. Type: string (or Expression with resultType string).
     * 
     * @param input the input value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withInput(Object input) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withInput(input);
        return this;
    }

    /**
     * Get the output property: Output blob path. Type: string (or Expression with resultType string).
     * 
     * @return the output value.
     */
    public Object output() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().output();
    }

    /**
     * Set the output property: Output blob path. Type: string (or Expression with resultType string).
     * 
     * @param output the output value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withOutput(Object output) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withOutput(output);
        return this;
    }

    /**
     * Get the filePaths property: Paths to streaming job files. Can be directories.
     * 
     * @return the filePaths value.
     */
    public List<Object> filePaths() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().filePaths();
    }

    /**
     * Set the filePaths property: Paths to streaming job files. Can be directories.
     * 
     * @param filePaths the filePaths value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withFilePaths(List<Object> filePaths) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withFilePaths(filePaths);
        return this;
    }

    /**
     * Get the fileLinkedService property: Linked service reference where the files are located.
     * 
     * @return the fileLinkedService value.
     */
    public LinkedServiceReference fileLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileLinkedService();
    }

    /**
     * Set the fileLinkedService property: Linked service reference where the files are located.
     * 
     * @param fileLinkedService the fileLinkedService value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withFileLinkedService(LinkedServiceReference fileLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withFileLinkedService(fileLinkedService);
        return this;
    }

    /**
     * Get the combiner property: Combiner executable name. Type: string (or Expression with resultType string).
     * 
     * @return the combiner value.
     */
    public Object combiner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().combiner();
    }

    /**
     * Set the combiner property: Combiner executable name. Type: string (or Expression with resultType string).
     * 
     * @param combiner the combiner value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withCombiner(Object combiner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withCombiner(combiner);
        return this;
    }

    /**
     * Get the commandEnvironment property: Command line environment values.
     * 
     * @return the commandEnvironment value.
     */
    public List<Object> commandEnvironment() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandEnvironment();
    }

    /**
     * Set the commandEnvironment property: Command line environment values.
     * 
     * @param commandEnvironment the commandEnvironment value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withCommandEnvironment(List<Object> commandEnvironment) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withCommandEnvironment(commandEnvironment);
        return this;
    }

    /**
     * Get the defines property: Allows user to specify defines for streaming job request.
     * 
     * @return the defines value.
     */
    public Map<String, Object> defines() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().defines();
    }

    /**
     * Set the defines property: Allows user to specify defines for streaming job request.
     * 
     * @param defines the defines value to set.
     * @return the HDInsightStreamingActivity object itself.
     */
    public HDInsightStreamingActivity withDefines(Map<String, Object> defines) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withDefines(defines);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model HDInsightStreamingActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HDInsightStreamingActivity.class);
}
