// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HiveLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Hive Server linked service.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = HiveLinkedService.class, visible = true)
@JsonTypeName("Hive")
@Fluent
public final class HiveLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Hive";

    /*
     * Hive Server linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private HiveLinkedServiceTypeProperties innerTypeProperties = new HiveLinkedServiceTypeProperties();

    /**
     * Creates an instance of HiveLinkedService class.
     */
    public HiveLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Hive Server linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private HiveLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HiveLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HiveLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HiveLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HiveLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the host property: IP address or host name of the Hive server, separated by ';' for multiple hosts (only when
     * serviceDiscoveryMode is enable).
     * 
     * @return the host value.
     */
    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    /**
     * Set the host property: IP address or host name of the Hive server, separated by ';' for multiple hosts (only when
     * serviceDiscoveryMode is enable).
     * 
     * @param host the host value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    /**
     * Get the port property: The TCP port that the Hive server uses to listen for client connections.
     * 
     * @return the port value.
     */
    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    /**
     * Set the port property: The TCP port that the Hive server uses to listen for client connections.
     * 
     * @param port the port value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    /**
     * Get the serverType property: The type of Hive server.
     * 
     * @return the serverType value.
     */
    public HiveServerType serverType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serverType();
    }

    /**
     * Set the serverType property: The type of Hive server.
     * 
     * @param serverType the serverType value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withServerType(HiveServerType serverType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServerType(serverType);
        return this;
    }

    /**
     * Get the thriftTransportProtocol property: The transport protocol to use in the Thrift layer.
     * 
     * @return the thriftTransportProtocol value.
     */
    public HiveThriftTransportProtocol thriftTransportProtocol() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().thriftTransportProtocol();
    }

    /**
     * Set the thriftTransportProtocol property: The transport protocol to use in the Thrift layer.
     * 
     * @param thriftTransportProtocol the thriftTransportProtocol value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withThriftTransportProtocol(HiveThriftTransportProtocol thriftTransportProtocol) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withThriftTransportProtocol(thriftTransportProtocol);
        return this;
    }

    /**
     * Get the authenticationType property: The authentication method used to access the Hive server.
     * 
     * @return the authenticationType value.
     */
    public HiveAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: The authentication method used to access the Hive server.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withAuthenticationType(HiveAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the serviceDiscoveryMode property: true to indicate using the ZooKeeper service, false not.
     * 
     * @return the serviceDiscoveryMode value.
     */
    public Object serviceDiscoveryMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serviceDiscoveryMode();
    }

    /**
     * Set the serviceDiscoveryMode property: true to indicate using the ZooKeeper service, false not.
     * 
     * @param serviceDiscoveryMode the serviceDiscoveryMode value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withServiceDiscoveryMode(Object serviceDiscoveryMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServiceDiscoveryMode(serviceDiscoveryMode);
        return this;
    }

    /**
     * Get the zooKeeperNameSpace property: The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     * 
     * @return the zooKeeperNameSpace value.
     */
    public Object zooKeeperNameSpace() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().zooKeeperNameSpace();
    }

    /**
     * Set the zooKeeperNameSpace property: The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     * 
     * @param zooKeeperNameSpace the zooKeeperNameSpace value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withZooKeeperNameSpace(Object zooKeeperNameSpace) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withZooKeeperNameSpace(zooKeeperNameSpace);
        return this;
    }

    /**
     * Get the useNativeQuery property: Specifies whether the driver uses native HiveQL queries,or converts them into an
     * equivalent form in HiveQL.
     * 
     * @return the useNativeQuery value.
     */
    public Object useNativeQuery() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useNativeQuery();
    }

    /**
     * Set the useNativeQuery property: Specifies whether the driver uses native HiveQL queries,or converts them into an
     * equivalent form in HiveQL.
     * 
     * @param useNativeQuery the useNativeQuery value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withUseNativeQuery(Object useNativeQuery) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseNativeQuery(useNativeQuery);
        return this;
    }

    /**
     * Get the username property: The user name that you use to access Hive Server.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: The user name that you use to access Hive Server.
     * 
     * @param username the username value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: The password corresponding to the user name that you provided in the Username field.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: The password corresponding to the user name that you provided in the Username field.
     * 
     * @param password the password value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the httpPath property: The partial URL corresponding to the Hive server.
     * 
     * @return the httpPath value.
     */
    public Object httpPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().httpPath();
    }

    /**
     * Set the httpPath property: The partial URL corresponding to the Hive server.
     * 
     * @param httpPath the httpPath value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withHttpPath(Object httpPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHttpPath(httpPath);
        return this;
    }

    /**
     * Get the enableSsl property: Specifies whether the connections to the server are encrypted using SSL. The default
     * value is false.
     * 
     * @return the enableSsl value.
     */
    public Object enableSsl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableSsl();
    }

    /**
     * Set the enableSsl property: Specifies whether the connections to the server are encrypted using SSL. The default
     * value is false.
     * 
     * @param enableSsl the enableSsl value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withEnableSsl(Object enableSsl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableSsl(enableSsl);
        return this;
    }

    /**
     * Get the trustedCertPath property: The full path of the .pem file containing trusted CA certificates for verifying
     * the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default
     * value is the cacerts.pem file installed with the IR.
     * 
     * @return the trustedCertPath value.
     */
    public Object trustedCertPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustedCertPath();
    }

    /**
     * Set the trustedCertPath property: The full path of the .pem file containing trusted CA certificates for verifying
     * the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default
     * value is the cacerts.pem file installed with the IR.
     * 
     * @param trustedCertPath the trustedCertPath value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withTrustedCertPath(Object trustedCertPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustedCertPath(trustedCertPath);
        return this;
    }

    /**
     * Get the useSystemTrustStore property: Specifies whether to use a CA certificate from the system trust store or
     * from a specified PEM file. The default value is false.
     * 
     * @return the useSystemTrustStore value.
     */
    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    /**
     * Set the useSystemTrustStore property: Specifies whether to use a CA certificate from the system trust store or
     * from a specified PEM file. The default value is false.
     * 
     * @param useSystemTrustStore the useSystemTrustStore value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    /**
     * Get the allowHostnameCNMismatch property: Specifies whether to require a CA-issued SSL certificate name to match
     * the host name of the server when connecting over SSL. The default value is false.
     * 
     * @return the allowHostnameCNMismatch value.
     */
    public Object allowHostnameCNMismatch() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowHostnameCNMismatch();
    }

    /**
     * Set the allowHostnameCNMismatch property: Specifies whether to require a CA-issued SSL certificate name to match
     * the host name of the server when connecting over SSL. The default value is false.
     * 
     * @param allowHostnameCNMismatch the allowHostnameCNMismatch value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowHostnameCNMismatch(allowHostnameCNMismatch);
        return this;
    }

    /**
     * Get the allowSelfSignedServerCert property: Specifies whether to allow self-signed certificates from the server.
     * The default value is false.
     * 
     * @return the allowSelfSignedServerCert value.
     */
    public Object allowSelfSignedServerCert() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowSelfSignedServerCert();
    }

    /**
     * Set the allowSelfSignedServerCert property: Specifies whether to allow self-signed certificates from the server.
     * The default value is false.
     * 
     * @param allowSelfSignedServerCert the allowSelfSignedServerCert value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowSelfSignedServerCert(allowSelfSignedServerCert);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the HiveLinkedService object itself.
     */
    public HiveLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model HiveLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HiveLinkedService.class);
}
