// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HttpLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Linked service for an HTTP source.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = HttpLinkedService.class, visible = true)
@JsonTypeName("HttpServer")
@Fluent
public final class HttpLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "HttpServer";

    /*
     * Properties specific to this linked service type.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private HttpLinkedServiceTypeProperties innerTypeProperties = new HttpLinkedServiceTypeProperties();

    /**
     * Creates an instance of HttpLinkedService class.
     */
    public HttpLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Properties specific to this linked service type.
     * 
     * @return the innerTypeProperties value.
     */
    private HttpLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HttpLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HttpLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HttpLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HttpLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the url property: The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or
     * Expression with resultType string).
     * 
     * @return the url value.
     */
    public Object url() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().url();
    }

    /**
     * Set the url property: The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or
     * Expression with resultType string).
     * 
     * @param url the url value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withUrl(Object url) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUrl(url);
        return this;
    }

    /**
     * Get the authenticationType property: The authentication type to be used to connect to the HTTP server.
     * 
     * @return the authenticationType value.
     */
    public HttpAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: The authentication type to be used to connect to the HTTP server.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withAuthenticationType(HttpAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the username property: User name for Basic, Digest, or Windows authentication. Type: string (or Expression
     * with resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: User name for Basic, Digest, or Windows authentication. Type: string (or Expression
     * with resultType string).
     * 
     * @param username the username value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData
     * authentication.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData
     * authentication.
     * 
     * @param password the password value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the authHeaders property: The additional HTTP headers in the request to RESTful API used for authorization.
     * Type: key value pairs (value should be string type).
     * 
     * @return the authHeaders value.
     */
    public Object authHeaders() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authHeaders();
    }

    /**
     * Set the authHeaders property: The additional HTTP headers in the request to RESTful API used for authorization.
     * Type: key value pairs (value should be string type).
     * 
     * @param authHeaders the authHeaders value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withAuthHeaders(Object authHeaders) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthHeaders(authHeaders);
        return this;
    }

    /**
     * Get the embeddedCertData property: Base64 encoded certificate data for ClientCertificate authentication. For
     * on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should
     * be specified. Type: string (or Expression with resultType string).
     * 
     * @return the embeddedCertData value.
     */
    public Object embeddedCertData() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().embeddedCertData();
    }

    /**
     * Set the embeddedCertData property: Base64 encoded certificate data for ClientCertificate authentication. For
     * on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should
     * be specified. Type: string (or Expression with resultType string).
     * 
     * @param embeddedCertData the embeddedCertData value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withEmbeddedCertData(Object embeddedCertData) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEmbeddedCertData(embeddedCertData);
        return this;
    }

    /**
     * Get the certThumbprint property: Thumbprint of certificate for ClientCertificate authentication. Only valid for
     * on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or
     * EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
     * 
     * @return the certThumbprint value.
     */
    public Object certThumbprint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().certThumbprint();
    }

    /**
     * Set the certThumbprint property: Thumbprint of certificate for ClientCertificate authentication. Only valid for
     * on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or
     * EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
     * 
     * @param certThumbprint the certThumbprint value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withCertThumbprint(Object certThumbprint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCertThumbprint(certThumbprint);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Get the enableServerCertificateValidation property: If true, validate the HTTPS server SSL certificate. Default
     * value is true. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the enableServerCertificateValidation value.
     */
    public Object enableServerCertificateValidation() {
        return this.innerTypeProperties() == null
            ? null
            : this.innerTypeProperties().enableServerCertificateValidation();
    }

    /**
     * Set the enableServerCertificateValidation property: If true, validate the HTTPS server SSL certificate. Default
     * value is true. Type: boolean (or Expression with resultType boolean).
     * 
     * @param enableServerCertificateValidation the enableServerCertificateValidation value to set.
     * @return the HttpLinkedService object itself.
     */
    public HttpLinkedService withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableServerCertificateValidation(enableServerCertificateValidation);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model HttpLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HttpLinkedService.class);
}
