// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The location of http server.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = HttpServerLocation.class, visible = true)
@JsonTypeName("HttpServerLocation")
@Fluent
public final class HttpServerLocation extends DatasetLocation {
    /*
     * Type of dataset storage location.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "HttpServerLocation";

    /*
     * Specify the relativeUrl of http server. Type: string (or Expression with resultType string)
     */
    @JsonProperty(value = "relativeUrl")
    private Object relativeUrl;

    /**
     * Creates an instance of HttpServerLocation class.
     */
    public HttpServerLocation() {
    }

    /**
     * Get the type property: Type of dataset storage location.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the relativeUrl property: Specify the relativeUrl of http server. Type: string (or Expression with resultType
     * string).
     * 
     * @return the relativeUrl value.
     */
    public Object relativeUrl() {
        return this.relativeUrl;
    }

    /**
     * Set the relativeUrl property: Specify the relativeUrl of http server. Type: string (or Expression with resultType
     * string).
     * 
     * @param relativeUrl the relativeUrl value to set.
     * @return the HttpServerLocation object itself.
     */
    public HttpServerLocation withRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HttpServerLocation withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HttpServerLocation withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
