// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The definition and properties of virtual network to which Azure-SSIS integration runtime will join.
 */
@Fluent
public final class IntegrationRuntimeCustomerVirtualNetwork {
    /*
     * The ID of subnet to which Azure-SSIS integration runtime will join.
     */
    @JsonProperty(value = "subnetId")
    private String subnetId;

    /**
     * Creates an instance of IntegrationRuntimeCustomerVirtualNetwork class.
     */
    public IntegrationRuntimeCustomerVirtualNetwork() {
    }

    /**
     * Get the subnetId property: The ID of subnet to which Azure-SSIS integration runtime will join.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set the subnetId property: The ID of subnet to which Azure-SSIS integration runtime will join.
     * 
     * @param subnetId the subnetId value to set.
     * @return the IntegrationRuntimeCustomerVirtualNetwork object itself.
     */
    public IntegrationRuntimeCustomerVirtualNetwork withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
