// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The edition for the SSIS Integration Runtime.
 */
public final class IntegrationRuntimeEdition extends ExpandableStringEnum<IntegrationRuntimeEdition> {
    /**
     * Static value Standard for IntegrationRuntimeEdition.
     */
    public static final IntegrationRuntimeEdition STANDARD = fromString("Standard");

    /**
     * Static value Enterprise for IntegrationRuntimeEdition.
     */
    public static final IntegrationRuntimeEdition ENTERPRISE = fromString("Enterprise");

    /**
     * Creates a new instance of IntegrationRuntimeEdition value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IntegrationRuntimeEdition() {
    }

    /**
     * Creates or finds a IntegrationRuntimeEdition from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IntegrationRuntimeEdition.
     */
    @JsonCreator
    public static IntegrationRuntimeEdition fromString(String name) {
        return fromString(name, IntegrationRuntimeEdition.class);
    }

    /**
     * Gets known IntegrationRuntimeEdition values.
     * 
     * @return known IntegrationRuntimeEdition values.
     */
    public static Collection<IntegrationRuntimeEdition> values() {
        return values(IntegrationRuntimeEdition.class);
    }
}
