// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of IntegrationRuntimeObjectMetadatas.
 */
public interface IntegrationRuntimeObjectMetadatas {
    /**
     * Refresh a SSIS integration runtime object metadata.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the operation.
     */
    SsisObjectMetadataStatusResponse refresh(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Refresh a SSIS integration runtime object metadata.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the operation.
     */
    SsisObjectMetadataStatusResponse refresh(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context);

    /**
     * Get a SSIS integration runtime object metadata by specified path. The return is pageable metadata list.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param getMetadataRequest The parameters for getting a SSIS object metadata.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a SSIS integration runtime object metadata by specified path along with {@link Response}.
     */
    Response<SsisObjectMetadataListResponse> getWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, GetSsisObjectMetadataRequest getMetadataRequest, Context context);

    /**
     * Get a SSIS integration runtime object metadata by specified path. The return is pageable metadata list.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a SSIS integration runtime object metadata by specified path.
     */
    SsisObjectMetadataListResponse get(String resourceGroupName, String factoryName, String integrationRuntimeName);
}
