// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The endpoint for Azure-SSIS integration runtime outbound network dependency.
 */
@Fluent
public final class IntegrationRuntimeOutboundNetworkDependenciesEndpoint {
    /*
     * The domain name of endpoint.
     */
    @JsonProperty(value = "domainName")
    private String domainName;

    /*
     * The details of endpoint.
     */
    @JsonProperty(value = "endpointDetails")
    private List<IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails> endpointDetails;

    /**
     * Creates an instance of IntegrationRuntimeOutboundNetworkDependenciesEndpoint class.
     */
    public IntegrationRuntimeOutboundNetworkDependenciesEndpoint() {
    }

    /**
     * Get the domainName property: The domain name of endpoint.
     * 
     * @return the domainName value.
     */
    public String domainName() {
        return this.domainName;
    }

    /**
     * Set the domainName property: The domain name of endpoint.
     * 
     * @param domainName the domainName value to set.
     * @return the IntegrationRuntimeOutboundNetworkDependenciesEndpoint object itself.
     */
    public IntegrationRuntimeOutboundNetworkDependenciesEndpoint withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    /**
     * Get the endpointDetails property: The details of endpoint.
     * 
     * @return the endpointDetails value.
     */
    public List<IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails> endpointDetails() {
        return this.endpointDetails;
    }

    /**
     * Set the endpointDetails property: The details of endpoint.
     * 
     * @param endpointDetails the endpointDetails value to set.
     * @return the IntegrationRuntimeOutboundNetworkDependenciesEndpoint object itself.
     */
    public IntegrationRuntimeOutboundNetworkDependenciesEndpoint
        withEndpointDetails(List<IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails> endpointDetails) {
        this.endpointDetails = endpointDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointDetails() != null) {
            endpointDetails().forEach(e -> e.validate());
        }
    }
}
