// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Integration runtime reference type.
 */
@Fluent
public final class IntegrationRuntimeReference {
    /*
     * Type of integration runtime.
     */
    @JsonProperty(value = "type", required = true)
    private String type = "IntegrationRuntimeReference";

    /*
     * Reference integration runtime name.
     */
    @JsonProperty(value = "referenceName", required = true)
    private String referenceName;

    /*
     * Arguments for integration runtime.
     */
    @JsonProperty(value = "parameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> parameters;

    /**
     * Creates an instance of IntegrationRuntimeReference class.
     */
    public IntegrationRuntimeReference() {
    }

    /**
     * Get the type property: Type of integration runtime.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of integration runtime.
     * 
     * @param type the type value to set.
     * @return the IntegrationRuntimeReference object itself.
     */
    public IntegrationRuntimeReference withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference integration runtime name.
     * 
     * @return the referenceName value.
     */
    public String referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference integration runtime name.
     * 
     * @param referenceName the referenceName value to set.
     * @return the IntegrationRuntimeReference object itself.
     */
    public IntegrationRuntimeReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Get the parameters property: Arguments for integration runtime.
     * 
     * @return the parameters value.
     */
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Arguments for integration runtime.
     * 
     * @param parameters the parameters value to set.
     * @return the IntegrationRuntimeReference object itself.
     */
    public IntegrationRuntimeReference withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model IntegrationRuntimeReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeReference.class);
}
