// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The pricing tier for the catalog database. The valid values could be found in
 * https://azure.microsoft.com/en-us/pricing/details/sql-database/.
 */
public final class IntegrationRuntimeSsisCatalogPricingTier
    extends ExpandableStringEnum<IntegrationRuntimeSsisCatalogPricingTier> {
    /**
     * Static value Basic for IntegrationRuntimeSsisCatalogPricingTier.
     */
    public static final IntegrationRuntimeSsisCatalogPricingTier BASIC = fromString("Basic");

    /**
     * Static value Standard for IntegrationRuntimeSsisCatalogPricingTier.
     */
    public static final IntegrationRuntimeSsisCatalogPricingTier STANDARD = fromString("Standard");

    /**
     * Static value Premium for IntegrationRuntimeSsisCatalogPricingTier.
     */
    public static final IntegrationRuntimeSsisCatalogPricingTier PREMIUM = fromString("Premium");

    /**
     * Static value PremiumRS for IntegrationRuntimeSsisCatalogPricingTier.
     */
    public static final IntegrationRuntimeSsisCatalogPricingTier PREMIUM_RS = fromString("PremiumRS");

    /**
     * Creates a new instance of IntegrationRuntimeSsisCatalogPricingTier value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IntegrationRuntimeSsisCatalogPricingTier() {
    }

    /**
     * Creates or finds a IntegrationRuntimeSsisCatalogPricingTier from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IntegrationRuntimeSsisCatalogPricingTier.
     */
    @JsonCreator
    public static IntegrationRuntimeSsisCatalogPricingTier fromString(String name) {
        return fromString(name, IntegrationRuntimeSsisCatalogPricingTier.class);
    }

    /**
     * Gets known IntegrationRuntimeSsisCatalogPricingTier values.
     * 
     * @return known IntegrationRuntimeSsisCatalogPricingTier values.
     */
    public static Collection<IntegrationRuntimeSsisCatalogPricingTier> values() {
        return values(IntegrationRuntimeSsisCatalogPricingTier.class);
    }
}
