// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * SSIS properties for managed integration runtime.
 */
@Fluent
public final class IntegrationRuntimeSsisProperties {
    /*
     * Catalog information for managed dedicated integration runtime.
     */
    @JsonProperty(value = "catalogInfo")
    private IntegrationRuntimeSsisCatalogInfo catalogInfo;

    /*
     * License type for bringing your own license scenario.
     */
    @JsonProperty(value = "licenseType")
    private IntegrationRuntimeLicenseType licenseType;

    /*
     * Custom setup script properties for a managed dedicated integration runtime.
     */
    @JsonProperty(value = "customSetupScriptProperties")
    private IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties;

    /*
     * Data proxy properties for a managed dedicated integration runtime.
     */
    @JsonProperty(value = "dataProxyProperties")
    private IntegrationRuntimeDataProxyProperties dataProxyProperties;

    /*
     * The edition for the SSIS Integration Runtime
     */
    @JsonProperty(value = "edition")
    private IntegrationRuntimeEdition edition;

    /*
     * Custom setup without script properties for a SSIS integration runtime.
     */
    @JsonProperty(value = "expressCustomSetupProperties")
    private List<CustomSetupBase> expressCustomSetupProperties;

    /*
     * Package stores for the SSIS Integration Runtime.
     */
    @JsonProperty(value = "packageStores")
    private List<PackageStore> packageStores;

    /*
     * The credential reference containing authentication information.
     */
    @JsonProperty(value = "credential")
    private CredentialReference credential;

    /*
     * SSIS properties for managed integration runtime.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of IntegrationRuntimeSsisProperties class.
     */
    public IntegrationRuntimeSsisProperties() {
    }

    /**
     * Get the catalogInfo property: Catalog information for managed dedicated integration runtime.
     * 
     * @return the catalogInfo value.
     */
    public IntegrationRuntimeSsisCatalogInfo catalogInfo() {
        return this.catalogInfo;
    }

    /**
     * Set the catalogInfo property: Catalog information for managed dedicated integration runtime.
     * 
     * @param catalogInfo the catalogInfo value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties withCatalogInfo(IntegrationRuntimeSsisCatalogInfo catalogInfo) {
        this.catalogInfo = catalogInfo;
        return this;
    }

    /**
     * Get the licenseType property: License type for bringing your own license scenario.
     * 
     * @return the licenseType value.
     */
    public IntegrationRuntimeLicenseType licenseType() {
        return this.licenseType;
    }

    /**
     * Set the licenseType property: License type for bringing your own license scenario.
     * 
     * @param licenseType the licenseType value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties withLicenseType(IntegrationRuntimeLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    /**
     * Get the customSetupScriptProperties property: Custom setup script properties for a managed dedicated integration
     * runtime.
     * 
     * @return the customSetupScriptProperties value.
     */
    public IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties() {
        return this.customSetupScriptProperties;
    }

    /**
     * Set the customSetupScriptProperties property: Custom setup script properties for a managed dedicated integration
     * runtime.
     * 
     * @param customSetupScriptProperties the customSetupScriptProperties value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties
        withCustomSetupScriptProperties(IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties) {
        this.customSetupScriptProperties = customSetupScriptProperties;
        return this;
    }

    /**
     * Get the dataProxyProperties property: Data proxy properties for a managed dedicated integration runtime.
     * 
     * @return the dataProxyProperties value.
     */
    public IntegrationRuntimeDataProxyProperties dataProxyProperties() {
        return this.dataProxyProperties;
    }

    /**
     * Set the dataProxyProperties property: Data proxy properties for a managed dedicated integration runtime.
     * 
     * @param dataProxyProperties the dataProxyProperties value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties
        withDataProxyProperties(IntegrationRuntimeDataProxyProperties dataProxyProperties) {
        this.dataProxyProperties = dataProxyProperties;
        return this;
    }

    /**
     * Get the edition property: The edition for the SSIS Integration Runtime.
     * 
     * @return the edition value.
     */
    public IntegrationRuntimeEdition edition() {
        return this.edition;
    }

    /**
     * Set the edition property: The edition for the SSIS Integration Runtime.
     * 
     * @param edition the edition value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties withEdition(IntegrationRuntimeEdition edition) {
        this.edition = edition;
        return this;
    }

    /**
     * Get the expressCustomSetupProperties property: Custom setup without script properties for a SSIS integration
     * runtime.
     * 
     * @return the expressCustomSetupProperties value.
     */
    public List<CustomSetupBase> expressCustomSetupProperties() {
        return this.expressCustomSetupProperties;
    }

    /**
     * Set the expressCustomSetupProperties property: Custom setup without script properties for a SSIS integration
     * runtime.
     * 
     * @param expressCustomSetupProperties the expressCustomSetupProperties value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties
        withExpressCustomSetupProperties(List<CustomSetupBase> expressCustomSetupProperties) {
        this.expressCustomSetupProperties = expressCustomSetupProperties;
        return this;
    }

    /**
     * Get the packageStores property: Package stores for the SSIS Integration Runtime.
     * 
     * @return the packageStores value.
     */
    public List<PackageStore> packageStores() {
        return this.packageStores;
    }

    /**
     * Set the packageStores property: Package stores for the SSIS Integration Runtime.
     * 
     * @param packageStores the packageStores value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties withPackageStores(List<PackageStore> packageStores) {
        this.packageStores = packageStores;
        return this;
    }

    /**
     * Get the credential property: The credential reference containing authentication information.
     * 
     * @return the credential value.
     */
    public CredentialReference credential() {
        return this.credential;
    }

    /**
     * Set the credential property: The credential reference containing authentication information.
     * 
     * @param credential the credential value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Get the additionalProperties property: SSIS properties for managed integration runtime.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: SSIS properties for managed integration runtime.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the IntegrationRuntimeSsisProperties object itself.
     */
    public IntegrationRuntimeSsisProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (catalogInfo() != null) {
            catalogInfo().validate();
        }
        if (customSetupScriptProperties() != null) {
            customSetupScriptProperties().validate();
        }
        if (dataProxyProperties() != null) {
            dataProxyProperties().validate();
        }
        if (expressCustomSetupProperties() != null) {
            expressCustomSetupProperties().forEach(e -> e.validate());
        }
        if (packageStores() != null) {
            packageStores().forEach(e -> e.validate());
        }
        if (credential() != null) {
            credential().validate();
        }
    }
}
