// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Linked service debug resource.
 */
@Fluent
public final class LinkedServiceDebugResource extends SubResourceDebugResource {
    /*
     * Properties of linked service.
     */
    @JsonProperty(value = "properties", required = true)
    private LinkedService properties;

    /**
     * Creates an instance of LinkedServiceDebugResource class.
     */
    public LinkedServiceDebugResource() {
    }

    /**
     * Get the properties property: Properties of linked service.
     * 
     * @return the properties value.
     */
    public LinkedService properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of linked service.
     * 
     * @param properties the properties value to set.
     * @return the LinkedServiceDebugResource object itself.
     */
    public LinkedServiceDebugResource withProperties(LinkedService properties) {
        this.properties = properties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LinkedServiceDebugResource withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model LinkedServiceDebugResource"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceDebugResource.class);
}
