// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Linked service reference type.
 */
@Fluent
public final class LinkedServiceReference {
    /*
     * Linked service reference type.
     */
    @JsonProperty(value = "type", required = true)
    private String type = "LinkedServiceReference";

    /*
     * Reference LinkedService name.
     */
    @JsonProperty(value = "referenceName", required = true)
    private String referenceName;

    /*
     * Arguments for LinkedService.
     */
    @JsonProperty(value = "parameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> parameters;

    /**
     * Creates an instance of LinkedServiceReference class.
     */
    public LinkedServiceReference() {
    }

    /**
     * Get the type property: Linked service reference type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Linked service reference type.
     * 
     * @param type the type value to set.
     * @return the LinkedServiceReference object itself.
     */
    public LinkedServiceReference withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference LinkedService name.
     * 
     * @return the referenceName value.
     */
    public String referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference LinkedService name.
     * 
     * @param referenceName the referenceName value to set.
     * @return the LinkedServiceReference object itself.
     */
    public LinkedServiceReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Get the parameters property: Arguments for LinkedService.
     * 
     * @return the parameters value.
     */
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Arguments for LinkedService.
     * 
     * @param parameters the parameters value to set.
     * @return the LinkedServiceReference object itself.
     */
    public LinkedServiceReference withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model LinkedServiceReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceReference.class);
}
