// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.LinkedServiceResourceInner;

/**
 * An immutable client-side representation of LinkedServiceResource.
 */
public interface LinkedServiceResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the properties property: Properties of linked service.
     * 
     * @return the properties value.
     */
    LinkedService properties();

    /**
     * Gets the name property: The resource name.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The resource type.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: Etag identifies change in the resource.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.datafactory.fluent.models.LinkedServiceResourceInner object.
     * 
     * @return the inner object.
     */
    LinkedServiceResourceInner innerModel();

    /**
     * The entirety of the LinkedServiceResource definition.
     */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithParentResource,
        DefinitionStages.WithProperties, DefinitionStages.WithCreate {
    }

    /**
     * The LinkedServiceResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the LinkedServiceResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the LinkedServiceResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, factoryName.
             * 
             * @param resourceGroupName The resource group name.
             * @param factoryName The factory name.
             * @return the next definition stage.
             */
            WithProperties withExistingFactory(String resourceGroupName, String factoryName);
        }

        /**
         * The stage of the LinkedServiceResource definition allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Properties of linked service..
             * 
             * @param properties Properties of linked service.
             * @return the next definition stage.
             */
            WithCreate withProperties(LinkedService properties);
        }

        /**
         * The stage of the LinkedServiceResource definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            LinkedServiceResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            LinkedServiceResource create(Context context);
        }

        /**
         * The stage of the LinkedServiceResource definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the linkedService entity. Should only be specified for update,
             * for which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the linkedService entity. Should only be specified for update, for which it should
             * match existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the LinkedServiceResource resource.
     * 
     * @return the stage of resource update.
     */
    LinkedServiceResource.Update update();

    /**
     * The template for LinkedServiceResource update.
     */
    interface Update extends UpdateStages.WithProperties, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        LinkedServiceResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        LinkedServiceResource apply(Context context);
    }

    /**
     * The LinkedServiceResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the LinkedServiceResource update allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Properties of linked service..
             * 
             * @param properties Properties of linked service.
             * @return the next definition stage.
             */
            Update withProperties(LinkedService properties);
        }

        /**
         * The stage of the LinkedServiceResource update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the linkedService entity. Should only be specified for update,
             * for which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the linkedService entity. Should only be specified for update, for which it should
             * match existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    LinkedServiceResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    LinkedServiceResource refresh(Context context);
}
