// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Log settings.
 */
@Fluent
public final class LogSettings {
    /*
     * Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "enableCopyActivityLog")
    private Object enableCopyActivityLog;

    /*
     * Specifies settings for copy activity log.
     */
    @JsonProperty(value = "copyActivityLogSettings")
    private CopyActivityLogSettings copyActivityLogSettings;

    /*
     * Log location settings customer needs to provide when enabling log.
     */
    @JsonProperty(value = "logLocationSettings", required = true)
    private LogLocationSettings logLocationSettings;

    /**
     * Creates an instance of LogSettings class.
     */
    public LogSettings() {
    }

    /**
     * Get the enableCopyActivityLog property: Specifies whether to enable copy activity log. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @return the enableCopyActivityLog value.
     */
    public Object enableCopyActivityLog() {
        return this.enableCopyActivityLog;
    }

    /**
     * Set the enableCopyActivityLog property: Specifies whether to enable copy activity log. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @param enableCopyActivityLog the enableCopyActivityLog value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withEnableCopyActivityLog(Object enableCopyActivityLog) {
        this.enableCopyActivityLog = enableCopyActivityLog;
        return this;
    }

    /**
     * Get the copyActivityLogSettings property: Specifies settings for copy activity log.
     * 
     * @return the copyActivityLogSettings value.
     */
    public CopyActivityLogSettings copyActivityLogSettings() {
        return this.copyActivityLogSettings;
    }

    /**
     * Set the copyActivityLogSettings property: Specifies settings for copy activity log.
     * 
     * @param copyActivityLogSettings the copyActivityLogSettings value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withCopyActivityLogSettings(CopyActivityLogSettings copyActivityLogSettings) {
        this.copyActivityLogSettings = copyActivityLogSettings;
        return this;
    }

    /**
     * Get the logLocationSettings property: Log location settings customer needs to provide when enabling log.
     * 
     * @return the logLocationSettings value.
     */
    public LogLocationSettings logLocationSettings() {
        return this.logLocationSettings;
    }

    /**
     * Set the logLocationSettings property: Log location settings customer needs to provide when enabling log.
     * 
     * @param logLocationSettings the logLocationSettings value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withLogLocationSettings(LogLocationSettings logLocationSettings) {
        this.logLocationSettings = logLocationSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (copyActivityLogSettings() != null) {
            copyActivityLogSettings().validate();
        }
        if (logLocationSettings() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property logLocationSettings in model LogSettings"));
        } else {
            logLocationSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogSettings.class);
}
