// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.LookupActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Lookup activity.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = LookupActivity.class, visible = true)
@JsonTypeName("Lookup")
@Fluent
public final class LookupActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Lookup";

    /*
     * Lookup activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private LookupActivityTypeProperties innerTypeProperties = new LookupActivityTypeProperties();

    /**
     * Creates an instance of LookupActivity class.
     */
    public LookupActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Lookup activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private LookupActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LookupActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the source property: Dataset-specific source properties, same as copy activity source.
     * 
     * @return the source value.
     */
    public CopySource source() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().source();
    }

    /**
     * Set the source property: Dataset-specific source properties, same as copy activity source.
     * 
     * @param source the source value to set.
     * @return the LookupActivity object itself.
     */
    public LookupActivity withSource(CopySource source) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LookupActivityTypeProperties();
        }
        this.innerTypeProperties().withSource(source);
        return this;
    }

    /**
     * Get the dataset property: Lookup activity dataset reference.
     * 
     * @return the dataset value.
     */
    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    /**
     * Set the dataset property: Lookup activity dataset reference.
     * 
     * @param dataset the dataset value to set.
     * @return the LookupActivity object itself.
     */
    public LookupActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LookupActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    /**
     * Get the firstRowOnly property: Whether to return first row or all rows. Default value is true. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @return the firstRowOnly value.
     */
    public Object firstRowOnly() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().firstRowOnly();
    }

    /**
     * Set the firstRowOnly property: Whether to return first row or all rows. Default value is true. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @param firstRowOnly the firstRowOnly value to set.
     * @return the LookupActivity object itself.
     */
    public LookupActivity withFirstRowOnly(Object firstRowOnly) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LookupActivityTypeProperties();
        }
        this.innerTypeProperties().withFirstRowOnly(firstRowOnly);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model LookupActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LookupActivity.class);
}
