// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIdentityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Managed identity credential.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = ManagedIdentityCredential.class,
    visible = true)
@JsonTypeName("ManagedIdentity")
@Fluent
public final class ManagedIdentityCredential extends Credential {
    /*
     * Type of credential.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "ManagedIdentity";

    /*
     * Managed identity credential properties.
     */
    @JsonProperty(value = "typeProperties")
    private ManagedIdentityTypeProperties innerTypeProperties;

    /**
     * Creates an instance of ManagedIdentityCredential class.
     */
    public ManagedIdentityCredential() {
    }

    /**
     * Get the type property: Type of credential.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Managed identity credential properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ManagedIdentityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedIdentityCredential withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedIdentityCredential withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the resourceId property: The resource id of user assigned managed identity.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceId();
    }

    /**
     * Set the resourceId property: The resource id of user assigned managed identity.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ManagedIdentityCredential object itself.
     */
    public ManagedIdentityCredential withResourceId(String resourceId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIdentityTypeProperties();
        }
        this.innerTypeProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
