// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CredentialResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Credential resource type.
 */
@Fluent
public final class ManagedIdentityCredentialResource extends CredentialResourceInner {
    /*
     * Managed Identity Credential properties.
     */
    @JsonProperty(value = "properties", required = true)
    private ManagedIdentityCredential properties;

    /**
     * Creates an instance of ManagedIdentityCredentialResource class.
     */
    public ManagedIdentityCredentialResource() {
    }

    /**
     * Get the properties property: Managed Identity Credential properties.
     * 
     * @return the properties value.
     */
    public ManagedIdentityCredential properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Managed Identity Credential properties.
     * 
     * @param properties the properties value to set.
     * @return the ManagedIdentityCredentialResource object itself.
     */
    public ManagedIdentityCredentialResource withProperties(ManagedIdentityCredential properties) {
        this.properties = properties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedIdentityCredentialResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model ManagedIdentityCredentialResource"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedIdentityCredentialResource.class);
}
