// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Properties of managed integration runtime operation result.
 */
@Fluent
public final class ManagedIntegrationRuntimeOperationResult {
    /*
     * The operation type. Could be start or stop.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The start time of the operation.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /*
     * The operation result.
     */
    @JsonProperty(value = "result", access = JsonProperty.Access.WRITE_ONLY)
    private String result;

    /*
     * The error code.
     */
    @JsonProperty(value = "errorCode", access = JsonProperty.Access.WRITE_ONLY)
    private String errorCode;

    /*
     * Managed integration runtime error parameters.
     */
    @JsonProperty(value = "parameters", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> parameters;

    /*
     * The activity id for the operation request.
     */
    @JsonProperty(value = "activityId", access = JsonProperty.Access.WRITE_ONLY)
    private String activityId;

    /*
     * Properties of managed integration runtime operation result.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ManagedIntegrationRuntimeOperationResult class.
     */
    public ManagedIntegrationRuntimeOperationResult() {
    }

    /**
     * Get the type property: The operation type. Could be start or stop.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the startTime property: The start time of the operation.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the result property: The operation result.
     * 
     * @return the result value.
     */
    public String result() {
        return this.result;
    }

    /**
     * Get the errorCode property: The error code.
     * 
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Get the parameters property: Managed integration runtime error parameters.
     * 
     * @return the parameters value.
     */
    public List<String> parameters() {
        return this.parameters;
    }

    /**
     * Get the activityId property: The activity id for the operation request.
     * 
     * @return the activityId value.
     */
    public String activityId() {
        return this.activityId;
    }

    /**
     * Get the additionalProperties property: Properties of managed integration runtime operation result.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Properties of managed integration runtime operation result.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ManagedIntegrationRuntimeOperationResult object itself.
     */
    public ManagedIntegrationRuntimeOperationResult withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
