// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIntegrationRuntimeStatusTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Managed integration runtime status.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = ManagedIntegrationRuntimeStatus.class,
    visible = true)
@JsonTypeName("Managed")
@Immutable
public final class ManagedIntegrationRuntimeStatus extends IntegrationRuntimeStatus {
    /*
     * Type of integration runtime.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private IntegrationRuntimeType type = IntegrationRuntimeType.MANAGED;

    /*
     * Managed integration runtime status type properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ManagedIntegrationRuntimeStatusTypeProperties innerTypeProperties
        = new ManagedIntegrationRuntimeStatusTypeProperties();

    /**
     * Creates an instance of ManagedIntegrationRuntimeStatus class.
     */
    public ManagedIntegrationRuntimeStatus() {
    }

    /**
     * Get the type property: Type of integration runtime.
     * 
     * @return the type value.
     */
    @Override
    public IntegrationRuntimeType type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Managed integration runtime status type properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ManagedIntegrationRuntimeStatusTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * Get the createTime property: The time at which the integration runtime was created, in ISO8601 format.
     * 
     * @return the createTime value.
     */
    public OffsetDateTime createTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().createTime();
    }

    /**
     * Get the nodes property: The list of nodes for managed integration runtime.
     * 
     * @return the nodes value.
     */
    public List<ManagedIntegrationRuntimeNode> nodes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nodes();
    }

    /**
     * Get the otherErrors property: The errors that occurred on this integration runtime.
     * 
     * @return the otherErrors value.
     */
    public List<ManagedIntegrationRuntimeError> otherErrors() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().otherErrors();
    }

    /**
     * Get the lastOperation property: The last operation result that occurred on this integration runtime.
     * 
     * @return the lastOperation value.
     */
    public ManagedIntegrationRuntimeOperationResult lastOperation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().lastOperation();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ManagedIntegrationRuntimeStatus"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedIntegrationRuntimeStatus.class);
}
