// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Properties of a managed private endpoint.
 */
@Fluent
public final class ManagedPrivateEndpoint {
    /*
     * The managed private endpoint connection state
     */
    @JsonProperty(value = "connectionState")
    private ConnectionStateProperties connectionState;

    /*
     * Fully qualified domain names
     */
    @JsonProperty(value = "fqdns")
    private List<String> fqdns;

    /*
     * The groupId to which the managed private endpoint is created
     */
    @JsonProperty(value = "groupId")
    private String groupId;

    /*
     * Denotes whether the managed private endpoint is reserved
     */
    @JsonProperty(value = "isReserved", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isReserved;

    /*
     * The ARM resource ID of the resource to which the managed private endpoint is created
     */
    @JsonProperty(value = "privateLinkResourceId")
    private String privateLinkResourceId;

    /*
     * The managed private endpoint provisioning state
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * Properties of a managed private endpoint
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ManagedPrivateEndpoint class.
     */
    public ManagedPrivateEndpoint() {
    }

    /**
     * Get the connectionState property: The managed private endpoint connection state.
     * 
     * @return the connectionState value.
     */
    public ConnectionStateProperties connectionState() {
        return this.connectionState;
    }

    /**
     * Set the connectionState property: The managed private endpoint connection state.
     * 
     * @param connectionState the connectionState value to set.
     * @return the ManagedPrivateEndpoint object itself.
     */
    public ManagedPrivateEndpoint withConnectionState(ConnectionStateProperties connectionState) {
        this.connectionState = connectionState;
        return this;
    }

    /**
     * Get the fqdns property: Fully qualified domain names.
     * 
     * @return the fqdns value.
     */
    public List<String> fqdns() {
        return this.fqdns;
    }

    /**
     * Set the fqdns property: Fully qualified domain names.
     * 
     * @param fqdns the fqdns value to set.
     * @return the ManagedPrivateEndpoint object itself.
     */
    public ManagedPrivateEndpoint withFqdns(List<String> fqdns) {
        this.fqdns = fqdns;
        return this;
    }

    /**
     * Get the groupId property: The groupId to which the managed private endpoint is created.
     * 
     * @return the groupId value.
     */
    public String groupId() {
        return this.groupId;
    }

    /**
     * Set the groupId property: The groupId to which the managed private endpoint is created.
     * 
     * @param groupId the groupId value to set.
     * @return the ManagedPrivateEndpoint object itself.
     */
    public ManagedPrivateEndpoint withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
     * Get the isReserved property: Denotes whether the managed private endpoint is reserved.
     * 
     * @return the isReserved value.
     */
    public Boolean isReserved() {
        return this.isReserved;
    }

    /**
     * Get the privateLinkResourceId property: The ARM resource ID of the resource to which the managed private endpoint
     * is created.
     * 
     * @return the privateLinkResourceId value.
     */
    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    /**
     * Set the privateLinkResourceId property: The ARM resource ID of the resource to which the managed private endpoint
     * is created.
     * 
     * @param privateLinkResourceId the privateLinkResourceId value to set.
     * @return the ManagedPrivateEndpoint object itself.
     */
    public ManagedPrivateEndpoint withPrivateLinkResourceId(String privateLinkResourceId) {
        this.privateLinkResourceId = privateLinkResourceId;
        return this;
    }

    /**
     * Get the provisioningState property: The managed private endpoint provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the additionalProperties property: Properties of a managed private endpoint.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Properties of a managed private endpoint.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ManagedPrivateEndpoint object itself.
     */
    public ManagedPrivateEndpoint withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionState() != null) {
            connectionState().validate();
        }
    }
}
