// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Managed Virtual Network reference type.
 */
@Fluent
public final class ManagedVirtualNetworkReference {
    /*
     * Managed Virtual Network reference type.
     */
    @JsonProperty(value = "type", required = true)
    private ManagedVirtualNetworkReferenceType type;

    /*
     * Reference ManagedVirtualNetwork name.
     */
    @JsonProperty(value = "referenceName", required = true)
    private String referenceName;

    /**
     * Creates an instance of ManagedVirtualNetworkReference class.
     */
    public ManagedVirtualNetworkReference() {
    }

    /**
     * Get the type property: Managed Virtual Network reference type.
     * 
     * @return the type value.
     */
    public ManagedVirtualNetworkReferenceType type() {
        return this.type;
    }

    /**
     * Set the type property: Managed Virtual Network reference type.
     * 
     * @param type the type value to set.
     * @return the ManagedVirtualNetworkReference object itself.
     */
    public ManagedVirtualNetworkReference withType(ManagedVirtualNetworkReferenceType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference ManagedVirtualNetwork name.
     * 
     * @return the referenceName value.
     */
    public String referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference ManagedVirtualNetwork name.
     * 
     * @param referenceName the referenceName value to set.
     * @return the ManagedVirtualNetworkReference object itself.
     */
    public ManagedVirtualNetworkReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model ManagedVirtualNetworkReference"));
        }
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model ManagedVirtualNetworkReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedVirtualNetworkReference.class);
}
