// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Source and target column mapping details.
 */
@Fluent
public final class MapperAttributeMapping {
    /*
     * Name of the target column.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
     */
    @JsonProperty(value = "type")
    private MappingType type;

    /*
     * Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type mapping.
     */
    @JsonProperty(value = "functionName")
    private String functionName;

    /*
     * Expression used for 'Aggregate' and 'Derived' type mapping.
     */
    @JsonProperty(value = "expression")
    private String expression;

    /*
     * Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
     */
    @JsonProperty(value = "attributeReference")
    private MapperAttributeReference attributeReference;

    /*
     * List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JsonProperty(value = "attributeReferences")
    private List<MapperAttributeReference> attributeReferences;

    /**
     * Creates an instance of MapperAttributeMapping class.
     */
    public MapperAttributeMapping() {
    }

    /**
     * Get the name property: Name of the target column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the target column.
     * 
     * @param name the name value to set.
     * @return the MapperAttributeMapping object itself.
     */
    public MapperAttributeMapping withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as
     * 'Derived'.
     * 
     * @return the type value.
     */
    public MappingType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as
     * 'Derived'.
     * 
     * @param type the type value to set.
     * @return the MapperAttributeMapping object itself.
     */
    public MapperAttributeMapping withType(MappingType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the functionName property: Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type
     * mapping.
     * 
     * @return the functionName value.
     */
    public String functionName() {
        return this.functionName;
    }

    /**
     * Set the functionName property: Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type
     * mapping.
     * 
     * @param functionName the functionName value to set.
     * @return the MapperAttributeMapping object itself.
     */
    public MapperAttributeMapping withFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Get the expression property: Expression used for 'Aggregate' and 'Derived' type mapping.
     * 
     * @return the expression value.
     */
    public String expression() {
        return this.expression;
    }

    /**
     * Set the expression property: Expression used for 'Aggregate' and 'Derived' type mapping.
     * 
     * @param expression the expression value to set.
     * @return the MapperAttributeMapping object itself.
     */
    public MapperAttributeMapping withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Get the attributeReference property: Reference of the source column used in the mapping. It is used for 'Direct'
     * mapping type only.
     * 
     * @return the attributeReference value.
     */
    public MapperAttributeReference attributeReference() {
        return this.attributeReference;
    }

    /**
     * Set the attributeReference property: Reference of the source column used in the mapping. It is used for 'Direct'
     * mapping type only.
     * 
     * @param attributeReference the attributeReference value to set.
     * @return the MapperAttributeMapping object itself.
     */
    public MapperAttributeMapping withAttributeReference(MapperAttributeReference attributeReference) {
        this.attributeReference = attributeReference;
        return this;
    }

    /**
     * Get the attributeReferences property: List of references for source columns. It is used for 'Derived' and
     * 'Aggregate' type mappings only.
     * 
     * @return the attributeReferences value.
     */
    public List<MapperAttributeReference> attributeReferences() {
        return this.attributeReferences;
    }

    /**
     * Set the attributeReferences property: List of references for source columns. It is used for 'Derived' and
     * 'Aggregate' type mappings only.
     * 
     * @param attributeReferences the attributeReferences value to set.
     * @return the MapperAttributeMapping object itself.
     */
    public MapperAttributeMapping withAttributeReferences(List<MapperAttributeReference> attributeReferences) {
        this.attributeReferences = attributeReferences;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attributeReference() != null) {
            attributeReference().validate();
        }
        if (attributeReferences() != null) {
            attributeReferences().forEach(e -> e.validate());
        }
    }
}
