// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Attribute mapping details.
 */
@Fluent
public final class MapperAttributeMappings {
    /*
     * List of attribute mappings.
     */
    @JsonProperty(value = "attributeMappings")
    private List<MapperAttributeMapping> attributeMappings;

    /**
     * Creates an instance of MapperAttributeMappings class.
     */
    public MapperAttributeMappings() {
    }

    /**
     * Get the attributeMappings property: List of attribute mappings.
     * 
     * @return the attributeMappings value.
     */
    public List<MapperAttributeMapping> attributeMappings() {
        return this.attributeMappings;
    }

    /**
     * Set the attributeMappings property: List of attribute mappings.
     * 
     * @param attributeMappings the attributeMappings value to set.
     * @return the MapperAttributeMappings object itself.
     */
    public MapperAttributeMappings withAttributeMappings(List<MapperAttributeMapping> attributeMappings) {
        this.attributeMappings = attributeMappings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attributeMappings() != null) {
            attributeMappings().forEach(e -> e.validate());
        }
    }
}
