// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Attribute reference details for the referred column.
 */
@Fluent
public final class MapperAttributeReference {
    /*
     * Name of the column.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Name of the table.
     */
    @JsonProperty(value = "entity")
    private String entity;

    /*
     * The connection reference for the connection.
     */
    @JsonProperty(value = "entityConnectionReference")
    private MapperConnectionReference entityConnectionReference;

    /**
     * Creates an instance of MapperAttributeReference class.
     */
    public MapperAttributeReference() {
    }

    /**
     * Get the name property: Name of the column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the column.
     * 
     * @param name the name value to set.
     * @return the MapperAttributeReference object itself.
     */
    public MapperAttributeReference withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the entity property: Name of the table.
     * 
     * @return the entity value.
     */
    public String entity() {
        return this.entity;
    }

    /**
     * Set the entity property: Name of the table.
     * 
     * @param entity the entity value to set.
     * @return the MapperAttributeReference object itself.
     */
    public MapperAttributeReference withEntity(String entity) {
        this.entity = entity;
        return this;
    }

    /**
     * Get the entityConnectionReference property: The connection reference for the connection.
     * 
     * @return the entityConnectionReference value.
     */
    public MapperConnectionReference entityConnectionReference() {
        return this.entityConnectionReference;
    }

    /**
     * Set the entityConnectionReference property: The connection reference for the connection.
     * 
     * @param entityConnectionReference the entityConnectionReference value to set.
     * @return the MapperAttributeReference object itself.
     */
    public MapperAttributeReference withEntityConnectionReference(MapperConnectionReference entityConnectionReference) {
        this.entityConnectionReference = entityConnectionReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (entityConnectionReference() != null) {
            entityConnectionReference().validate();
        }
    }
}
