// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Source connection details.
 */
@Fluent
public final class MapperConnection {
    /*
     * Linked service reference.
     */
    @JsonProperty(value = "linkedService")
    private LinkedServiceReference linkedService;

    /*
     * Type of the linked service e.g.: AzureBlobFS.
     */
    @JsonProperty(value = "linkedServiceType")
    private String linkedServiceType;

    /*
     * Type of connection via linked service or dataset.
     */
    @JsonProperty(value = "type", required = true)
    private ConnectionType type;

    /*
     * A boolean indicating whether linked service is of type inline dataset. Currently only inline datasets are supported.
     */
    @JsonProperty(value = "isInlineDataset")
    private Boolean isInlineDataset;

    /*
     * List of name/value pairs for connection properties.
     */
    @JsonProperty(value = "commonDslConnectorProperties")
    private List<MapperDslConnectorProperties> commonDslConnectorProperties;

    /**
     * Creates an instance of MapperConnection class.
     */
    public MapperConnection() {
    }

    /**
     * Get the linkedService property: Linked service reference.
     * 
     * @return the linkedService value.
     */
    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    /**
     * Set the linkedService property: Linked service reference.
     * 
     * @param linkedService the linkedService value to set.
     * @return the MapperConnection object itself.
     */
    public MapperConnection withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    /**
     * Get the linkedServiceType property: Type of the linked service e.g.: AzureBlobFS.
     * 
     * @return the linkedServiceType value.
     */
    public String linkedServiceType() {
        return this.linkedServiceType;
    }

    /**
     * Set the linkedServiceType property: Type of the linked service e.g.: AzureBlobFS.
     * 
     * @param linkedServiceType the linkedServiceType value to set.
     * @return the MapperConnection object itself.
     */
    public MapperConnection withLinkedServiceType(String linkedServiceType) {
        this.linkedServiceType = linkedServiceType;
        return this;
    }

    /**
     * Get the type property: Type of connection via linked service or dataset.
     * 
     * @return the type value.
     */
    public ConnectionType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of connection via linked service or dataset.
     * 
     * @param type the type value to set.
     * @return the MapperConnection object itself.
     */
    public MapperConnection withType(ConnectionType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the isInlineDataset property: A boolean indicating whether linked service is of type inline dataset.
     * Currently only inline datasets are supported.
     * 
     * @return the isInlineDataset value.
     */
    public Boolean isInlineDataset() {
        return this.isInlineDataset;
    }

    /**
     * Set the isInlineDataset property: A boolean indicating whether linked service is of type inline dataset.
     * Currently only inline datasets are supported.
     * 
     * @param isInlineDataset the isInlineDataset value to set.
     * @return the MapperConnection object itself.
     */
    public MapperConnection withIsInlineDataset(Boolean isInlineDataset) {
        this.isInlineDataset = isInlineDataset;
        return this;
    }

    /**
     * Get the commonDslConnectorProperties property: List of name/value pairs for connection properties.
     * 
     * @return the commonDslConnectorProperties value.
     */
    public List<MapperDslConnectorProperties> commonDslConnectorProperties() {
        return this.commonDslConnectorProperties;
    }

    /**
     * Set the commonDslConnectorProperties property: List of name/value pairs for connection properties.
     * 
     * @param commonDslConnectorProperties the commonDslConnectorProperties value to set.
     * @return the MapperConnection object itself.
     */
    public MapperConnection
        withCommonDslConnectorProperties(List<MapperDslConnectorProperties> commonDslConnectorProperties) {
        this.commonDslConnectorProperties = commonDslConnectorProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedService() != null) {
            linkedService().validate();
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model MapperConnection"));
        }
        if (commonDslConnectorProperties() != null) {
            commonDslConnectorProperties().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MapperConnection.class);
}
